/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.geoportal.model.content;

import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElements;
import org.gcube.application.geoportal.model.AccessPolicy;
import org.gcube.application.geoportal.model.Record;
import org.gcube.application.geoportal.model.concessioni.LayerConcessione;
import org.gcube.application.geoportal.model.concessioni.RelazioneScavo;
import org.gcube.application.geoportal.model.content.GeoServerContent;
import org.gcube.application.geoportal.model.content.OtherContent;
import org.gcube.application.geoportal.model.content.PersistedContent;
import org.gcube.application.geoportal.model.content.UploadedImage;
import org.gcube.application.geoportal.model.content.WorkspaceContent;
import org.gcube.application.geoportal.model.gis.SDILayerDescriptor;
import org.gcube.application.geoportal.model.report.Check;
import org.gcube.application.geoportal.model.report.ValidationReport;
import org.hibernate.annotations.LazyCollection;
import org.hibernate.annotations.LazyCollectionOption;

@Entity
@Inheritance(strategy=InheritanceType.JOINED)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="type")
@JsonSubTypes(value={@JsonSubTypes.Type(value=OtherContent.class), @JsonSubTypes.Type(value=RelazioneScavo.class), @JsonSubTypes.Type(value=SDILayerDescriptor.class), @JsonSubTypes.Type(value=LayerConcessione.class), @JsonSubTypes.Type(value=UploadedImage.class)})
public abstract class AssociatedContent {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private long id;
    @XmlElement
    private AccessPolicy policy;
    private String licenseID;
    private String titolo;
    private LocalDateTime creationTime;
    @ManyToOne
    @JoinColumn(name="record_id", nullable=false)
    private Record record;
    @LazyCollection(value=LazyCollectionOption.FALSE)
    @OneToMany(mappedBy="associated", cascade={CascadeType.ALL})
    @XmlElements(value={@XmlElement(type=GeoServerContent.class), @XmlElement(type=WorkspaceContent.class)})
    private List<PersistedContent> actualContent = new ArrayList<PersistedContent>();

    public ValidationReport validateForInsertion() {
        ValidationReport toReturn = new ValidationReport("Associated Content");
        toReturn.checkMandatory(this.policy, "Politica di accesso", new Check[0]);
        toReturn.checkMandatory(this.licenseID, "Licenza", new Check[0]);
        toReturn.checkMandatory(this.titolo, "Titolo", new Check[0]);
        toReturn.checkMandatory(this.creationTime, "Creation time", new Check[0]);
        return toReturn;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("AssociatedContent [id=");
        builder.append(this.id);
        if (this.record != null) {
            builder.append(", owner-record-id=");
            builder.append(this.record.getId());
        } else {
            builder.append(", record=");
            builder.append(this.record);
        }
        builder.append(", policy=");
        builder.append((Object)this.policy);
        builder.append(", licenseID=");
        builder.append(this.licenseID);
        builder.append(", titolo=");
        builder.append(this.titolo);
        builder.append(", creationTime=");
        builder.append(this.creationTime);
        builder.append(", actualContent=");
        builder.append(this.actualContent);
        builder.append("]");
        return builder.toString();
    }

    public long getId() {
        return this.id;
    }

    public AccessPolicy getPolicy() {
        return this.policy;
    }

    public String getLicenseID() {
        return this.licenseID;
    }

    public String getTitolo() {
        return this.titolo;
    }

    public LocalDateTime getCreationTime() {
        return this.creationTime;
    }

    public Record getRecord() {
        return this.record;
    }

    public List<PersistedContent> getActualContent() {
        return this.actualContent;
    }

    public void setId(long id) {
        this.id = id;
    }

    public void setPolicy(AccessPolicy policy) {
        this.policy = policy;
    }

    public void setLicenseID(String licenseID) {
        this.licenseID = licenseID;
    }

    public void setTitolo(String titolo) {
        this.titolo = titolo;
    }

    public void setCreationTime(LocalDateTime creationTime) {
        this.creationTime = creationTime;
    }

    public void setRecord(Record record) {
        this.record = record;
    }

    public void setActualContent(List<PersistedContent> actualContent) {
        this.actualContent = actualContent;
    }
}

