/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.geoportal.model.concessioni;

import java.util.List;
import javax.persistence.DiscriminatorValue;
import javax.persistence.ElementCollection;
import javax.persistence.Entity;
import org.gcube.application.geoportal.model.gis.BBOX;
import org.gcube.application.geoportal.model.gis.SDILayerDescriptor;
import org.gcube.application.geoportal.model.report.Check;
import org.gcube.application.geoportal.model.report.ValidationReport;
import org.hibernate.annotations.LazyCollection;
import org.hibernate.annotations.LazyCollectionOption;
import org.hibernate.annotations.Type;

@Entity
@DiscriminatorValue(value="LAYER_CONCESSIONE")
public class LayerConcessione
extends SDILayerDescriptor {
    private String layerUUID;
    private Long layerID;
    private String layerName;
    @Type(type="text")
    private String WMSLink;
    @Type(type="text")
    private String abstractSection;
    private String topicCategory;
    private String subTopic;
    private BBOX bbox;
    @LazyCollection(value=LazyCollectionOption.FALSE)
    @ElementCollection(targetClass=String.class)
    private List<String> paroleChiaveLibere;
    @LazyCollection(value=LazyCollectionOption.FALSE)
    @ElementCollection(targetClass=String.class)
    private List<String> paroleChiaveICCD;
    @Type(type="text")
    private String valutazioneQualita;
    @Type(type="text")
    private String metodoRaccoltaDati;
    private String scalaAcquisizione;
    @LazyCollection(value=LazyCollectionOption.FALSE)
    @ElementCollection(targetClass=String.class)
    private List<String> authors;
    private String responsabile;

    @Override
    public ValidationReport validateForInsertion() {
        ValidationReport toReturn = super.validateForInsertion();
        toReturn.setObjectName("Layer Concessione");
        toReturn.checkMandatory(this.abstractSection, "Abstract", new Check[0]);
        toReturn.checkMandatory(this.subTopic, "Categoria (Topic)", new Check[0]);
        toReturn.checkMandatory(this.valutazioneQualita, "Valutazione della qualita", new Check[0]);
        toReturn.checkMandatory(this.metodoRaccoltaDati, "Metodo raccolta dati", new Check[0]);
        toReturn.checkMandatory(this.scalaAcquisizione, "Scala acquisizione", new Check[0]);
        toReturn.checkMandatory(this.authors, "Autori", new Check[0]);
        return toReturn;
    }

    @Override
    public String getLayerUUID() {
        return this.layerUUID;
    }

    @Override
    public Long getLayerID() {
        return this.layerID;
    }

    @Override
    public String getLayerName() {
        return this.layerName;
    }

    @Override
    public String getWMSLink() {
        return this.WMSLink;
    }

    public String getAbstractSection() {
        return this.abstractSection;
    }

    public String getTopicCategory() {
        return this.topicCategory;
    }

    public String getSubTopic() {
        return this.subTopic;
    }

    public BBOX getBbox() {
        return this.bbox;
    }

    public List<String> getParoleChiaveLibere() {
        return this.paroleChiaveLibere;
    }

    public List<String> getParoleChiaveICCD() {
        return this.paroleChiaveICCD;
    }

    public String getValutazioneQualita() {
        return this.valutazioneQualita;
    }

    public String getMetodoRaccoltaDati() {
        return this.metodoRaccoltaDati;
    }

    public String getScalaAcquisizione() {
        return this.scalaAcquisizione;
    }

    public List<String> getAuthors() {
        return this.authors;
    }

    public String getResponsabile() {
        return this.responsabile;
    }

    @Override
    public void setLayerUUID(String layerUUID) {
        this.layerUUID = layerUUID;
    }

    @Override
    public void setLayerID(Long layerID) {
        this.layerID = layerID;
    }

    @Override
    public void setLayerName(String layerName) {
        this.layerName = layerName;
    }

    @Override
    public void setWMSLink(String WMSLink) {
        this.WMSLink = WMSLink;
    }

    public void setAbstractSection(String abstractSection) {
        this.abstractSection = abstractSection;
    }

    public void setTopicCategory(String topicCategory) {
        this.topicCategory = topicCategory;
    }

    public void setSubTopic(String subTopic) {
        this.subTopic = subTopic;
    }

    public void setBbox(BBOX bbox) {
        this.bbox = bbox;
    }

    public void setParoleChiaveLibere(List<String> paroleChiaveLibere) {
        this.paroleChiaveLibere = paroleChiaveLibere;
    }

    public void setParoleChiaveICCD(List<String> paroleChiaveICCD) {
        this.paroleChiaveICCD = paroleChiaveICCD;
    }

    public void setValutazioneQualita(String valutazioneQualita) {
        this.valutazioneQualita = valutazioneQualita;
    }

    public void setMetodoRaccoltaDati(String metodoRaccoltaDati) {
        this.metodoRaccoltaDati = metodoRaccoltaDati;
    }

    public void setScalaAcquisizione(String scalaAcquisizione) {
        this.scalaAcquisizione = scalaAcquisizione;
    }

    public void setAuthors(List<String> authors) {
        this.authors = authors;
    }

    public void setResponsabile(String responsabile) {
        this.responsabile = responsabile;
    }

    @Override
    public String toString() {
        return "LayerConcessione(super=" + super.toString() + ", layerUUID=" + this.getLayerUUID() + ", layerID=" + this.getLayerID() + ", layerName=" + this.getLayerName() + ", WMSLink=" + this.getWMSLink() + ", abstractSection=" + this.getAbstractSection() + ", topicCategory=" + this.getTopicCategory() + ", subTopic=" + this.getSubTopic() + ", bbox=" + this.getBbox() + ", paroleChiaveLibere=" + this.getParoleChiaveLibere() + ", paroleChiaveICCD=" + this.getParoleChiaveICCD() + ", valutazioneQualita=" + this.getValutazioneQualita() + ", metodoRaccoltaDati=" + this.getMetodoRaccoltaDati() + ", scalaAcquisizione=" + this.getScalaAcquisizione() + ", authors=" + this.getAuthors() + ", responsabile=" + this.getResponsabile() + ")";
    }
}

