/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.geoportal.managers;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.persistence.EntityManagerFactory;
import javax.persistence.SharedCacheMode;
import javax.persistence.ValidationMode;
import javax.persistence.spi.ClassTransformer;
import javax.persistence.spi.PersistenceUnitInfo;
import javax.persistence.spi.PersistenceUnitTransactionType;
import javax.sql.DataSource;
import jersey.repackaged.com.google.common.collect.ImmutableMap;
import org.gcube.application.geoportal.managers.EMFProvider;
import org.gcube.application.geoportal.model.db.DatabaseConnection;
import org.gcube.application.geoportal.model.fault.ConfigurationException;
import org.gcube.application.geoportal.utils.ISUtils;
import org.hibernate.dialect.PostgreSQLDialect;
import org.hibernate.jpa.HibernatePersistenceProvider;
import org.hibernate.tool.schema.Action;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefatulEMFProvider
implements EMFProvider {
    private static final Logger log = LoggerFactory.getLogger(DefatulEMFProvider.class);
    private static EntityManagerFactory emf = null;

    @Override
    public EntityManagerFactory getFactory() {
        if (emf == null) {
            try {
                DatabaseConnection conn = ISUtils.queryForDB("postgresql", "internal-db");
                log.debug("Found Internal Database : " + conn);
                emf = new HibernatePersistenceProvider().createContainerEntityManagerFactory(DefatulEMFProvider.archiverPersistenceUnitInfo(), (Map)ImmutableMap.builder().put((Object)"javax.persistence.jdbc.driver", (Object)"org.postgresql.Driver").put((Object)"javax.persistence.jdbc.url", (Object)conn.getUrl()).put((Object)"hibernate.dialect", PostgreSQLDialect.class).put((Object)"hibernate.hbm2ddl.auto", (Object)Action.UPDATE).put((Object)"hibernate.show_sql", (Object)false).put((Object)"hibernate.query.startup_check", (Object)false).put((Object)"hibernate.generate_statistics", (Object)false).put((Object)"hibernate.bytecode.use_reflection_optimizer", (Object)false).put((Object)"hibernate.cache.use_second_level_cache", (Object)false).put((Object)"hibernate.cache.use_query_cache", (Object)false).put((Object)"hibernate.cache.use_structured_entries", (Object)false).put((Object)"hibernate.jdbc.batch_size", (Object)20).put((Object)"javax.persistence.jdbc.user", (Object)conn.getUser()).put((Object)"javax.persistence.jdbc.password", (Object)conn.getPwd()).build());
            }
            catch (ConfigurationException e) {
                throw new RuntimeException("Unable to init EMF", e);
            }
        }
        return emf;
    }

    private static PersistenceUnitInfo archiverPersistenceUnitInfo() {
        final List<String> MANAGED_CLASSES = Arrays.asList("org.gcube.application.geoportal.model.Record", "org.gcube.application.geoportal.model.concessioni.Concessione", "org.gcube.application.geoportal.model.concessioni.LayerConcessione", "org.gcube.application.geoportal.model.concessioni.RelazioneScavo", "org.gcube.application.geoportal.model.content.AssociatedContent", "org.gcube.application.geoportal.model.content.GeoServerContent", "org.gcube.application.geoportal.model.content.OtherContent", "org.gcube.application.geoportal.model.content.PersistedContent", "org.gcube.application.geoportal.model.content.UploadedImage", "org.gcube.application.geoportal.model.content.WorkspaceContent", "org.gcube.application.geoportal.model.gis.ShapeFileLayerDescriptor", "org.gcube.application.geoportal.model.gis.SDILayerDescriptor");
        return new PersistenceUnitInfo(){

            public String getPersistenceUnitName() {
                return "ApplicationPersistenceUnit";
            }

            public String getPersistenceProviderClassName() {
                return "org.hibernate.jpa.HibernatePersistenceProvider";
            }

            public PersistenceUnitTransactionType getTransactionType() {
                return PersistenceUnitTransactionType.RESOURCE_LOCAL;
            }

            public DataSource getJtaDataSource() {
                return null;
            }

            public DataSource getNonJtaDataSource() {
                return null;
            }

            public List<String> getMappingFileNames() {
                return Collections.emptyList();
            }

            public List<URL> getJarFileUrls() {
                try {
                    return Collections.list(this.getClass().getClassLoader().getResources(""));
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }

            public URL getPersistenceUnitRootUrl() {
                return null;
            }

            public List<String> getManagedClassNames() {
                return MANAGED_CLASSES;
            }

            public boolean excludeUnlistedClasses() {
                return true;
            }

            public SharedCacheMode getSharedCacheMode() {
                return null;
            }

            public ValidationMode getValidationMode() {
                return null;
            }

            public Properties getProperties() {
                return new Properties();
            }

            public String getPersistenceXMLSchemaVersion() {
                return null;
            }

            public ClassLoader getClassLoader() {
                return null;
            }

            public void addTransformer(ClassTransformer transformer) {
            }

            public ClassLoader getNewTempClassLoader() {
                return null;
            }
        };
    }

    @Override
    public void shutdown() {
        if (emf != null) {
            if (emf.isOpen()) {
                emf.close();
            }
            emf = null;
        }
    }
}

