/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.geoportal.model.vre;

import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.core.Configuration;
import javax.ws.rs.core.Response;
import org.gcube.application.geoportal.model.fault.GenericWebException;
import org.gcube.application.geoportal.model.vre.GCubeUser;
import org.gcube.application.geoportal.utils.ISUtils;
import org.gcube.data.transfer.library.client.AuthorizationFilter;
import org.glassfish.jersey.client.ClientConfig;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SocialManager {
    private static final Logger log = LoggerFactory.getLogger(SocialManager.class);
    Client client;
    String baseUrl;

    private SocialManager() {
        log.debug("Looking for social networking..");
        this.baseUrl = ISUtils.getgCubeBaseEndpoint("Portal", "SocialNetworking");
        log.debug("Social Networking service is at " + this.baseUrl);
        ClientConfig config = new ClientConfig();
        config.register(AuthorizationFilter.class);
        this.client = (Client)ClientBuilder.newClient((Configuration)config).property("jersey.config.client.suppressHttpComplianceValidation", (Object)true);
    }

    private JSONObject read(String path) throws JSONException, GenericWebException {
        return SocialManager.check(this.client.target(this.baseUrl).path(path).request().get());
    }

    private static JSONObject check(Response resp) throws JSONException, GenericWebException {
        if (resp.getStatus() < 200 || resp.getStatus() >= 300) {
            String remoteMessage = (String)resp.readEntity(String.class);
            Integer httpCode = resp.getStatus();
            GenericWebException e = new GenericWebException("RESP STATUS IS " + httpCode + ". Message : " + remoteMessage);
            e.setRemoteMessage(remoteMessage);
            e.setResponseHTTPCode(httpCode);
            throw e;
        }
        String respString = (String)resp.readEntity(String.class);
        log.debug("Response is " + respString);
        return new JSONObject(respString);
    }

    public static GCubeUser getCurrentUser() {
        String id = "fakeID";
        String currentVRE = "fakeVRE";
        String name = "NO NAME";
        try {
            SocialManager manager = new SocialManager();
            JSONObject obj = manager.read("2/people/profile");
            if (!obj.getBoolean("success")) {
                throw new Exception("Service reported fail : " + obj.toString());
            }
            JSONObject result = obj.getJSONObject("result");
            currentVRE = result.getString("context");
            name = result.getString("fullname");
            id = result.getString("username");
        }
        catch (Throwable t) {
            log.warn("!!!!! UNABLE TO CONTACT SOCIAL NETWORKING SERVICE ", t);
        }
        return new GCubeUser(id, name, currentVRE);
    }
}

