/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.geoportal.managers;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.URL;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.EntityTransaction;
import javax.persistence.SharedCacheMode;
import javax.persistence.ValidationMode;
import javax.persistence.spi.ClassTransformer;
import javax.persistence.spi.PersistenceUnitInfo;
import javax.persistence.spi.PersistenceUnitTransactionType;
import javax.sql.DataSource;
import jersey.repackaged.com.google.common.collect.ImmutableMap;
import org.gcube.application.geoportal.model.Record;
import org.gcube.application.geoportal.model.db.DatabaseConnection;
import org.gcube.application.geoportal.model.db.PostgisTable;
import org.gcube.application.geoportal.model.fault.PersistenceException;
import org.gcube.application.geoportal.model.fault.PublishException;
import org.gcube.application.geoportal.model.fault.SDIInteractionException;
import org.gcube.application.geoportal.model.fault.ValidationException;
import org.gcube.application.geoportal.model.report.PublicationReport;
import org.gcube.application.geoportal.model.report.ValidationReport;
import org.gcube.application.geoportal.storage.ContentHandler;
import org.gcube.application.geoportal.storage.PostgisDBManager;
import org.gcube.application.geoportal.utils.ISUtils;
import org.hibernate.dialect.PostgreSQLDialect;
import org.hibernate.jpa.HibernatePersistenceProvider;
import org.hibernate.tool.schema.Action;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractRecordManager<T extends Record> {
    private static final Logger log = LoggerFactory.getLogger(AbstractRecordManager.class);
    private static final Object $LOCK = new Object[0];
    private static EMFProvider defaultProvider = null;
    private static EntityManagerFactory emf = null;
    EntityTransaction transaction = null;
    EntityManager entityManager = AbstractRecordManager.getEMF().createEntityManager();
    private T theRecord;
    private ContentHandler<T> contentHandler;

    public static void setDefaultProvider(EMFProvider provider) {
        defaultProvider = provider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static EntityManagerFactory getEMF() {
        Object object = $LOCK;
        synchronized (object) {
            if (emf == null) {
                try {
                    DatabaseConnection conn = ISUtils.queryForDB("postgresql", "internal-db");
                    log.debug("Found Internal Database : " + conn);
                    emf = new HibernatePersistenceProvider().createContainerEntityManagerFactory(AbstractRecordManager.archiverPersistenceUnitInfo(), (Map)ImmutableMap.builder().put((Object)"javax.persistence.jdbc.driver", (Object)"org.postgresql.Driver").put((Object)"javax.persistence.jdbc.url", (Object)conn.getUrl()).put((Object)"hibernate.dialect", PostgreSQLDialect.class).put((Object)"hibernate.hbm2ddl.auto", (Object)Action.UPDATE).put((Object)"hibernate.show_sql", (Object)true).put((Object)"hibernate.query.startup_check", (Object)false).put((Object)"hibernate.generate_statistics", (Object)false).put((Object)"hibernate.bytecode.use_reflection_optimizer", (Object)false).put((Object)"hibernate.cache.use_second_level_cache", (Object)false).put((Object)"hibernate.cache.use_query_cache", (Object)false).put((Object)"hibernate.cache.use_structured_entries", (Object)false).put((Object)"hibernate.jdbc.batch_size", (Object)20).put((Object)"javax.persistence.jdbc.user", (Object)conn.getUser()).put((Object)"javax.persistence.jdbc.password", (Object)conn.getPwd()).build());
                }
                catch (Throwable t) {
                    if (defaultProvider == null) {
                        throw new RuntimeException("NO INTERNAL DADATABASE. Please contact VRE Manager (Required SE [platform : postgresq, 'GNA-DB' flag : internal-db])");
                    }
                    log.warn("Found default provider. This should happen only in test phase.");
                    emf = defaultProvider.getFactory();
                }
            }
            return emf;
        }
    }

    public static void shutdown() {
        EntityManagerFactory emf = AbstractRecordManager.getEMF();
        emf.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Record getByID(long id) {
        EntityManager em = AbstractRecordManager.getEMF().createEntityManager();
        try {
            Record record = (Record)em.find(Record.class, (Object)id);
            return record;
        }
        finally {
            em.flush();
            em.close();
        }
    }

    protected T storeInfo() {
        log.debug("Storing Record " + this.theRecord);
        this.entityManager.persist(this.theRecord);
        return this.theRecord;
    }

    protected AbstractRecordManager(T theRecord) {
        this.transaction = this.entityManager.getTransaction();
        this.transaction.begin();
        this.theRecord = theRecord;
        this.storeInfo();
        this.contentHandler = new ContentHandler<T>(theRecord);
    }

    protected ContentHandler<T> getContentHandler() {
        return this.contentHandler;
    }

    public T getRecord() {
        return this.theRecord;
    }

    public T commit(boolean publish) throws PersistenceException, ValidationException, PublishException {
        log.trace("Committing record " + this.theRecord + " Publish is " + publish);
        ValidationReport report = ((Record)this.theRecord).validate();
        log.debug("Validated Report is " + report);
        if (publish && report.getStatus().equals((Object)ValidationReport.ValidationStatus.ERROR)) {
            throw new ValidationException(report, "Cannot publish project. See validation report");
        }
        log.debug("Record is valid, storing changed content");
        this.contentHandler.storeChanges(publish);
        if (publish) {
            log.debug("Registering centroid of " + this.theRecord);
            this.registerCentroid();
        }
        this.transaction.commit();
        return this.theRecord;
    }

    public PublicationReport commitSafely(boolean publish) {
        log.debug("Safely publishing " + this.theRecord);
        PublicationReport toReturn = new PublicationReport("Publication Report");
        toReturn.setTheRecord((Record)this.getRecord());
        ValidationReport validation = ((Record)this.theRecord).validate();
        validation.setObjectName("Validation report for " + validation.getObjectName());
        if (validation.getStatus().equals((Object)ValidationReport.ValidationStatus.ERROR)) {
            toReturn.addMessage(publish ? ValidationReport.ValidationStatus.ERROR : ValidationReport.ValidationStatus.WARNING, "Record not valid.");
        }
        toReturn.addChild(validation);
        log.debug("Record is valid, storing changed content [Publish is :" + publish + "]");
        try {
            toReturn.addChild(this.contentHandler.storeChanges(publish));
            if (publish) {
                log.debug("Registering centroid of " + this.theRecord);
                this.registerCentroid();
                toReturn.addMessage(ValidationReport.ValidationStatus.PASSED, "Inserito centroide per record " + ((Record)this.theRecord).getId());
            }
        }
        catch (PersistenceException e) {
            toReturn.addChild(e.getReport());
        }
        catch (PublishException e) {
            toReturn.addMessage(ValidationReport.ValidationStatus.WARNING, "Centroide non registrato");
        }
        try {
            log.info("Report is " + toReturn.prettyPrint());
        }
        catch (Exception e) {
            log.warn("Unable to pretty print report " + toReturn, (Throwable)e);
        }
        return toReturn;
    }

    protected void finalize() throws Throwable {
        if (this.transaction.isActive()) {
            this.transaction.rollback();
        }
        this.entityManager.flush();
        this.entityManager.close();
    }

    private void registerCentroid() throws PublishException {
        try {
            log.debug("Evaluating Centroid");
            Map<String, String> centroidRow = this.evaluateCentroid();
            log.debug("Contacting postgis DB .. ");
            PostgisDBManager db = PostgisDBManager.get();
            PostgisTable centroidsTable = this.getCentroidsTable();
            log.debug("Inserting / updated centroid Row {} ", centroidRow);
            PreparedStatement ps = db.prepareInsertStatement(centroidsTable, true, true);
            log.debug("Deleting centroid if present. ID is " + ((Record)this.theRecord).getId());
            db.deleteByFieldValue(centroidsTable, new PostgisTable.Field("product_id", PostgisTable.FieldType.TEXT), ((Record)this.theRecord).getId() + "");
            centroidsTable.fillCSVPreparedStatament(centroidRow, ps, false);
            ps.executeUpdate();
            db.commit();
            this.initCentroidLayer();
        }
        catch (SQLException e) {
            log.warn("Unable to publish Centroid for record " + this.theRecord, (Throwable)e);
            throw new PublishException("Unable to publish centroid.", e, null);
        }
        catch (SDIInteractionException e) {
            log.warn("Unable to publish Centroid Layer for record type " + (Object)((Object)((Record)this.getRecord()).getRecordType()), (Throwable)e);
            throw new PublishException("Unable to publish centroid.", e, null);
        }
    }

    protected abstract PostgisTable getCentroidsTable();

    protected abstract void initCentroidLayer() throws SDIInteractionException;

    protected abstract Map<String, String> evaluateCentroid();

    private static PersistenceUnitInfo archiverPersistenceUnitInfo() {
        final List<String> MANAGED_CLASSES = Arrays.asList("org.gcube.application.geoportal.model.Record", "org.gcube.application.geoportal.model.concessioni.Concessione", "org.gcube.application.geoportal.model.concessioni.LayerConcessione", "org.gcube.application.geoportal.model.concessioni.RelazioneScavo", "org.gcube.application.geoportal.model.content.AssociatedContent", "org.gcube.application.geoportal.model.content.GeoServerContent", "org.gcube.application.geoportal.model.content.OtherContent", "org.gcube.application.geoportal.model.content.PersistedContent", "org.gcube.application.geoportal.model.content.UploadedImage", "org.gcube.application.geoportal.model.content.WorkspaceContent", "org.gcube.application.geoportal.model.gis.ShapeFileLayerDescriptor", "org.gcube.application.geoportal.model.gis.SDILayerDescriptor");
        return new PersistenceUnitInfo(){

            public String getPersistenceUnitName() {
                return "ApplicationPersistenceUnit";
            }

            public String getPersistenceProviderClassName() {
                return "org.hibernate.jpa.HibernatePersistenceProvider";
            }

            public PersistenceUnitTransactionType getTransactionType() {
                return PersistenceUnitTransactionType.RESOURCE_LOCAL;
            }

            public DataSource getJtaDataSource() {
                return null;
            }

            public DataSource getNonJtaDataSource() {
                return null;
            }

            public List<String> getMappingFileNames() {
                return Collections.emptyList();
            }

            public List<URL> getJarFileUrls() {
                try {
                    return Collections.list(this.getClass().getClassLoader().getResources(""));
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }

            public URL getPersistenceUnitRootUrl() {
                return null;
            }

            public List<String> getManagedClassNames() {
                return MANAGED_CLASSES;
            }

            public boolean excludeUnlistedClasses() {
                return true;
            }

            public SharedCacheMode getSharedCacheMode() {
                return null;
            }

            public ValidationMode getValidationMode() {
                return null;
            }

            public Properties getProperties() {
                return new Properties();
            }

            public String getPersistenceXMLSchemaVersion() {
                return null;
            }

            public ClassLoader getClassLoader() {
                return null;
            }

            public void addTransformer(ClassTransformer transformer) {
            }

            public ClassLoader getNewTempClassLoader() {
                return null;
            }
        };
    }

    public static interface EMFProvider {
        public EntityManagerFactory getFactory();
    }
}

