/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.geoportal.model.concessioni;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.DiscriminatorValue;
import javax.persistence.ElementCollection;
import javax.persistence.Entity;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import org.gcube.application.geoportal.model.Record;
import org.gcube.application.geoportal.model.RecordType;
import org.gcube.application.geoportal.model.concessioni.LayerConcessione;
import org.gcube.application.geoportal.model.concessioni.RelazioneScavo;
import org.gcube.application.geoportal.model.content.OtherContent;
import org.gcube.application.geoportal.model.content.UploadedImage;
import org.gcube.application.geoportal.model.report.ValidationReport;
import org.gcube.application.geoportal.utils.CollectionsUtils;

@Entity
@DiscriminatorValue(value="CONCESSIONE")
public class Concessione
extends Record {
    private String introduzione;
    private String descrizioneContenuto;
    @ElementCollection(targetClass=String.class)
    private List<String> authors;
    private String contributore;
    @ElementCollection(targetClass=String.class)
    private List<String> titolari;
    private String responsabile;
    private String editore;
    @ElementCollection(targetClass=String.class)
    private List<String> fontiFinanziamento;
    @ElementCollection(targetClass=String.class)
    private List<String> soggetto;
    @ElementCollection(targetClass=String.class)
    private List<String> risorseCorrelate;
    private LocalDateTime dataInizioProgetto;
    private LocalDateTime dataFineProgetto;
    private String titolareLicenza;
    private String titolareCopyright;
    @ElementCollection(targetClass=String.class)
    private List<String> paroleChiaveLibere;
    @ElementCollection(targetClass=String.class)
    private List<String> paroleChiaveICCD;
    private Double centroidLat;
    private Double centroidLong;
    @OneToOne(cascade={CascadeType.ALL})
    private RelazioneScavo relazioneScavo;
    @OneToMany(mappedBy="record", cascade={CascadeType.ALL})
    private List<UploadedImage> immaginiRappresentative = new ArrayList<UploadedImage>();
    @OneToOne(cascade={CascadeType.ALL})
    private LayerConcessione posizionamentoScavo;
    @OneToMany(mappedBy="record", cascade={CascadeType.ALL})
    private List<LayerConcessione> pianteFineScavo = new ArrayList<LayerConcessione>();
    @OneToMany(mappedBy="record", cascade={CascadeType.ALL})
    private List<OtherContent> genericContent = new ArrayList<OtherContent>();

    public Concessione() {
        this.setRecordType(RecordType.CONCESSIONE);
    }

    @Override
    public ValidationReport validate() {
        ValidationReport validator = super.validate();
        validator.setObjectName("Concessione");
        validator.checkMandatory(this.authors, "Lista Autori");
        if (validator.checkMandatory(this.centroidLat, "Latitudine") && (this.centroidLat > 90.0 || this.centroidLat < -90.0)) {
            validator.addMessage(ValidationReport.ValidationStatus.ERROR, "Latitudine non valida : " + this.centroidLat);
        }
        if (validator.checkMandatory(this.centroidLong, "Longitudine") && (this.centroidLong > 180.0 || this.centroidLong < -180.0)) {
            validator.addMessage(ValidationReport.ValidationStatus.ERROR, "Longitudine non valida : " + this.centroidLong);
        }
        validator.checkMandatory(this.contributore, "Contributore");
        if (validator.checkMandatory(this.dataFineProgetto, "Data Fine Progetto") && validator.checkMandatory(this.dataInizioProgetto, "Data Inizio Progetto") && this.dataFineProgetto.isBefore(this.dataInizioProgetto)) {
            validator.addMessage(ValidationReport.ValidationStatus.ERROR, "Data Fine Progetto non pu\u00f2 esser prima di Data Inizio Progetto.");
        }
        validator.checkMandatory(this.descrizioneContenuto, "Descrizione contenuto");
        validator.checkMandatory(this.editore, "Editore");
        validator.checkMandatory(this.fontiFinanziamento, "Fonti Finanaziamento");
        validator.checkMandatory(this.introduzione, "Introduzione");
        validator.checkMandatory(this.paroleChiaveICCD, "Parole chiave ICCD");
        validator.checkMandatory(this.paroleChiaveLibere, "Parole chiave libere");
        if (this.genericContent != null) {
            for (OtherContent content : this.genericContent) {
                validator.addChild(content.validateForInsertion());
            }
        }
        if (validator.checkMandatory(this.pianteFineScavo, "Piante fine scavo")) {
            for (LayerConcessione l : this.pianteFineScavo) {
                validator.addChild(l.validateForInsertion());
            }
        }
        if (validator.checkMandatory(this.posizionamentoScavo, "Posizionamento scavo")) {
            ValidationReport posReport = this.posizionamentoScavo.validateForInsertion();
            posReport.setObjectName("Posizionamento scavo");
            validator.addChild(posReport);
        }
        if (validator.checkMandatory(this.relazioneScavo, "Relazione scavo")) {
            validator.addChild(this.relazioneScavo.validateForInsertion());
        }
        validator.checkMandatory(this.responsabile, "Responsabile");
        validator.checkMandatory(this.soggetto, "Soggetto");
        validator.checkMandatory(this.titolareCopyright, "Titolare Copyright");
        validator.checkMandatory(this.titolareLicenza, "Titolare licenza");
        validator.checkMandatory(this.titolari, "Titolari");
        return validator;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + CollectionsUtils.hashCode(this.authors);
        result = 31 * result + CollectionsUtils.hashCode(this.fontiFinanziamento);
        result = 31 * result + CollectionsUtils.hashCode(this.immaginiRappresentative);
        result = 31 * result + CollectionsUtils.hashCode(this.paroleChiaveICCD);
        result = 31 * result + CollectionsUtils.hashCode(this.paroleChiaveLibere);
        result = 31 * result + CollectionsUtils.hashCode(this.pianteFineScavo);
        result = 31 * result + CollectionsUtils.hashCode(this.risorseCorrelate);
        result = 31 * result + CollectionsUtils.hashCode(this.soggetto);
        result = 31 * result + CollectionsUtils.hashCode(this.titolari);
        result = 31 * result + (this.centroidLat == null ? 0 : this.centroidLat.hashCode());
        result = 31 * result + (this.centroidLong == null ? 0 : this.centroidLong.hashCode());
        result = 31 * result + (this.contributore == null ? 0 : this.contributore.hashCode());
        result = 31 * result + (this.dataFineProgetto == null ? 0 : this.dataFineProgetto.hashCode());
        result = 31 * result + (this.dataInizioProgetto == null ? 0 : this.dataInizioProgetto.hashCode());
        result = 31 * result + (this.descrizioneContenuto == null ? 0 : this.descrizioneContenuto.hashCode());
        result = 31 * result + (this.editore == null ? 0 : this.editore.hashCode());
        result = 31 * result + (this.genericContent == null ? 0 : this.genericContent.hashCode());
        result = 31 * result + (this.introduzione == null ? 0 : this.introduzione.hashCode());
        result = 31 * result + (this.posizionamentoScavo == null ? 0 : this.posizionamentoScavo.hashCode());
        result = 31 * result + (this.relazioneScavo == null ? 0 : this.relazioneScavo.hashCode());
        result = 31 * result + (this.responsabile == null ? 0 : this.responsabile.hashCode());
        result = 31 * result + (this.titolareCopyright == null ? 0 : this.titolareCopyright.hashCode());
        result = 31 * result + (this.titolareLicenza == null ? 0 : this.titolareLicenza.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Concessione other = (Concessione)obj;
        if (!CollectionsUtils.equalsCollections(this.authors, other.authors)) {
            return false;
        }
        if (!CollectionsUtils.equalsCollections(this.fontiFinanziamento, other.fontiFinanziamento)) {
            return false;
        }
        if (!CollectionsUtils.equalsCollections(this.immaginiRappresentative, other.immaginiRappresentative)) {
            return false;
        }
        if (!CollectionsUtils.equalsCollections(this.paroleChiaveICCD, other.paroleChiaveICCD)) {
            return false;
        }
        if (!CollectionsUtils.equalsCollections(this.paroleChiaveLibere, other.paroleChiaveLibere)) {
            return false;
        }
        if (!CollectionsUtils.equalsCollections(this.pianteFineScavo, other.pianteFineScavo)) {
            return false;
        }
        if (!CollectionsUtils.equalsCollections(this.risorseCorrelate, other.risorseCorrelate)) {
            return false;
        }
        if (!CollectionsUtils.equalsCollections(this.soggetto, other.soggetto)) {
            return false;
        }
        if (!CollectionsUtils.equalsCollections(this.titolari, other.titolari)) {
            return false;
        }
        if (this.centroidLat == null ? other.centroidLat != null : !this.centroidLat.equals(other.centroidLat)) {
            return false;
        }
        if (this.centroidLong == null ? other.centroidLong != null : !this.centroidLong.equals(other.centroidLong)) {
            return false;
        }
        if (this.contributore == null ? other.contributore != null : !this.contributore.equals(other.contributore)) {
            return false;
        }
        if (this.dataFineProgetto == null ? other.dataFineProgetto != null : !this.dataFineProgetto.equals(other.dataFineProgetto)) {
            return false;
        }
        if (this.dataInizioProgetto == null ? other.dataInizioProgetto != null : !this.dataInizioProgetto.equals(other.dataInizioProgetto)) {
            return false;
        }
        if (this.descrizioneContenuto == null ? other.descrizioneContenuto != null : !this.descrizioneContenuto.equals(other.descrizioneContenuto)) {
            return false;
        }
        if (this.editore == null ? other.editore != null : !this.editore.equals(other.editore)) {
            return false;
        }
        if (this.genericContent == null ? other.genericContent != null : !this.genericContent.equals(other.genericContent)) {
            return false;
        }
        if (this.introduzione == null ? other.introduzione != null : !this.introduzione.equals(other.introduzione)) {
            return false;
        }
        if (this.posizionamentoScavo == null ? other.posizionamentoScavo != null : !this.posizionamentoScavo.equals(other.posizionamentoScavo)) {
            return false;
        }
        if (this.relazioneScavo == null ? other.relazioneScavo != null : !this.relazioneScavo.equals(other.relazioneScavo)) {
            return false;
        }
        if (this.responsabile == null ? other.responsabile != null : !this.responsabile.equals(other.responsabile)) {
            return false;
        }
        if (this.titolareCopyright == null ? other.titolareCopyright != null : !this.titolareCopyright.equals(other.titolareCopyright)) {
            return false;
        }
        return !(this.titolareLicenza == null ? other.titolareLicenza != null : !this.titolareLicenza.equals(other.titolareLicenza));
    }

    public String getIntroduzione() {
        return this.introduzione;
    }

    public String getDescrizioneContenuto() {
        return this.descrizioneContenuto;
    }

    public List<String> getAuthors() {
        return this.authors;
    }

    public String getContributore() {
        return this.contributore;
    }

    public List<String> getTitolari() {
        return this.titolari;
    }

    public String getResponsabile() {
        return this.responsabile;
    }

    public String getEditore() {
        return this.editore;
    }

    public List<String> getFontiFinanziamento() {
        return this.fontiFinanziamento;
    }

    public List<String> getSoggetto() {
        return this.soggetto;
    }

    public List<String> getRisorseCorrelate() {
        return this.risorseCorrelate;
    }

    public LocalDateTime getDataInizioProgetto() {
        return this.dataInizioProgetto;
    }

    public LocalDateTime getDataFineProgetto() {
        return this.dataFineProgetto;
    }

    public String getTitolareLicenza() {
        return this.titolareLicenza;
    }

    public String getTitolareCopyright() {
        return this.titolareCopyright;
    }

    public List<String> getParoleChiaveLibere() {
        return this.paroleChiaveLibere;
    }

    public List<String> getParoleChiaveICCD() {
        return this.paroleChiaveICCD;
    }

    public Double getCentroidLat() {
        return this.centroidLat;
    }

    public Double getCentroidLong() {
        return this.centroidLong;
    }

    public RelazioneScavo getRelazioneScavo() {
        return this.relazioneScavo;
    }

    public List<UploadedImage> getImmaginiRappresentative() {
        return this.immaginiRappresentative;
    }

    public LayerConcessione getPosizionamentoScavo() {
        return this.posizionamentoScavo;
    }

    public List<LayerConcessione> getPianteFineScavo() {
        return this.pianteFineScavo;
    }

    public List<OtherContent> getGenericContent() {
        return this.genericContent;
    }

    public void setIntroduzione(String introduzione) {
        this.introduzione = introduzione;
    }

    public void setDescrizioneContenuto(String descrizioneContenuto) {
        this.descrizioneContenuto = descrizioneContenuto;
    }

    public void setAuthors(List<String> authors) {
        this.authors = authors;
    }

    public void setContributore(String contributore) {
        this.contributore = contributore;
    }

    public void setTitolari(List<String> titolari) {
        this.titolari = titolari;
    }

    public void setResponsabile(String responsabile) {
        this.responsabile = responsabile;
    }

    public void setEditore(String editore) {
        this.editore = editore;
    }

    public void setFontiFinanziamento(List<String> fontiFinanziamento) {
        this.fontiFinanziamento = fontiFinanziamento;
    }

    public void setSoggetto(List<String> soggetto) {
        this.soggetto = soggetto;
    }

    public void setRisorseCorrelate(List<String> risorseCorrelate) {
        this.risorseCorrelate = risorseCorrelate;
    }

    public void setDataInizioProgetto(LocalDateTime dataInizioProgetto) {
        this.dataInizioProgetto = dataInizioProgetto;
    }

    public void setDataFineProgetto(LocalDateTime dataFineProgetto) {
        this.dataFineProgetto = dataFineProgetto;
    }

    public void setTitolareLicenza(String titolareLicenza) {
        this.titolareLicenza = titolareLicenza;
    }

    public void setTitolareCopyright(String titolareCopyright) {
        this.titolareCopyright = titolareCopyright;
    }

    public void setParoleChiaveLibere(List<String> paroleChiaveLibere) {
        this.paroleChiaveLibere = paroleChiaveLibere;
    }

    public void setParoleChiaveICCD(List<String> paroleChiaveICCD) {
        this.paroleChiaveICCD = paroleChiaveICCD;
    }

    public void setCentroidLat(Double centroidLat) {
        this.centroidLat = centroidLat;
    }

    public void setCentroidLong(Double centroidLong) {
        this.centroidLong = centroidLong;
    }

    public void setRelazioneScavo(RelazioneScavo relazioneScavo) {
        this.relazioneScavo = relazioneScavo;
    }

    public void setImmaginiRappresentative(List<UploadedImage> immaginiRappresentative) {
        this.immaginiRappresentative = immaginiRappresentative;
    }

    public void setPosizionamentoScavo(LayerConcessione posizionamentoScavo) {
        this.posizionamentoScavo = posizionamentoScavo;
    }

    public void setPianteFineScavo(List<LayerConcessione> pianteFineScavo) {
        this.pianteFineScavo = pianteFineScavo;
    }

    public void setGenericContent(List<OtherContent> genericContent) {
        this.genericContent = genericContent;
    }

    @Override
    public String toString() {
        return "Concessione(super=" + super.toString() + ", introduzione=" + this.getIntroduzione() + ", descrizioneContenuto=" + this.getDescrizioneContenuto() + ", authors=" + this.getAuthors() + ", contributore=" + this.getContributore() + ", titolari=" + this.getTitolari() + ", responsabile=" + this.getResponsabile() + ", editore=" + this.getEditore() + ", fontiFinanziamento=" + this.getFontiFinanziamento() + ", soggetto=" + this.getSoggetto() + ", risorseCorrelate=" + this.getRisorseCorrelate() + ", dataInizioProgetto=" + this.getDataInizioProgetto() + ", dataFineProgetto=" + this.getDataFineProgetto() + ", titolareLicenza=" + this.getTitolareLicenza() + ", titolareCopyright=" + this.getTitolareCopyright() + ", paroleChiaveLibere=" + this.getParoleChiaveLibere() + ", paroleChiaveICCD=" + this.getParoleChiaveICCD() + ", centroidLat=" + this.getCentroidLat() + ", centroidLong=" + this.getCentroidLong() + ", relazioneScavo=" + this.getRelazioneScavo() + ", immaginiRappresentative=" + this.getImmaginiRappresentative() + ", posizionamentoScavo=" + this.getPosizionamentoScavo() + ", pianteFineScavo=" + this.getPianteFineScavo() + ", genericContent=" + this.getGenericContent() + ")";
    }
}

