package org.gcube.application.geoportalcommon.shared;

import java.io.Serializable;
import java.util.List;

/**
 * The Class ItemField.
 *
 * @author Francesco Mangiacrapa at ISTI-CNR francesco.mangiacrapa@isti.cnr.it
 * 
 *         Dec 21, 2021
 */
public class ItemField implements Serializable {

	/**
	 * 
	 */
	private static final long serialVersionUID = 1856714668390438433L;

	private String displayName;
	private List<String> jsonFields;
	private boolean sortable;
	private boolean searchable;
	private boolean displayAsResult;

	/**
	 * Instantiates a new item field.
	 */
	public ItemField() {

	}

	/**
	 * Instantiates a new item field.
	 *
	 * @param displayName     the display name
	 * @param jsonFields      the json fields
	 * @param displayAsResult the display as result
	 * @param sortable        the sortable
	 * @param searchable      the searchable
	 */
	public ItemField(String displayName, List<String> jsonFields, boolean displayAsResult, boolean sortable,
			boolean searchable) {
		super();
		this.displayName = displayName;
		this.jsonFields = jsonFields;
		this.displayAsResult = displayAsResult;
		this.sortable = sortable;
		this.searchable = searchable;
	}

	/**
	 * Gets the display name.
	 *
	 * @return the display name
	 */
	public String getDisplayName() {
		return displayName;
	}

	/**
	 * Gets the json fields.
	 *
	 * @return the json fields
	 */
	public List<String> getJsonFields() {
		return jsonFields;
	}

	/**
	 * Sets the display name.
	 *
	 * @param displayName the new display name
	 */
	public void setDisplayName(String displayName) {
		this.displayName = displayName;
	}

	/**
	 * Sets the json fields.
	 *
	 * @param jsonFields the new json fields
	 */
	public void setJsonFields(List<String> jsonFields) {
		this.jsonFields = jsonFields;
	}

	/**
	 * Checks if is sortable.
	 *
	 * @return true, if is sortable
	 */
	public boolean isSortable() {
		return sortable;
	}

	/**
	 * Sets the sortable.
	 *
	 * @param sortable the new sortable
	 */
	public void setSortable(boolean sortable) {
		this.sortable = sortable;
	}

	/**
	 * Checks if is searchable.
	 *
	 * @return true, if is searchable
	 */
	public boolean isSearchable() {
		return searchable;
	}

	/**
	 * Sets the searchable.
	 *
	 * @param searchable the new searchable
	 */
	public void setSearchable(boolean searchable) {
		this.searchable = searchable;
	}

	/**
	 * Checks if is display as result.
	 *
	 * @return true, if is display as result
	 */
	public boolean isDisplayAsResult() {
		return displayAsResult;
	}

	/**
	 * Sets the display as result.
	 *
	 * @param displayAsResult the new display as result
	 */
	public void setDisplayAsResult(boolean displayAsResult) {
		this.displayAsResult = displayAsResult;
	}

	/**
	 * To string.
	 *
	 * @return the string
	 */
	@Override
	public String toString() {
		StringBuilder builder = new StringBuilder();
		builder.append("ItemField [displayName=");
		builder.append(displayName);
		builder.append(", jsonFields=");
		builder.append(jsonFields);
		builder.append(", sortable=");
		builder.append(sortable);
		builder.append(", searchable=");
		builder.append(searchable);
		builder.append(", displayAsResult=");
		builder.append(displayAsResult);
		builder.append("]");
		return builder.toString();
	}

}
