package org.gcube.application.geoportalcommon.shared.products.model;

import java.io.Serializable;
import java.util.Date;


/**
 * The Class RecordDV.
 *
 * @author Francesco Mangiacrapa at ISTI-CNR francesco.mangiacrapa@isti.cnr.it
 * 
 * Aug 2, 2021
 */
public abstract class RecordDV implements Serializable {

	/**
	 * 
	 */
	private static final long serialVersionUID = 2913726613820175679L;

	/** The id. */
	// this is the mongoID
	private String itemId;

	/** The record type. */
	private String recordType;

	/** The version. */
	private String version = "1.0.0";

	/** The licenza ID. */
	private String licenzaID;

	private String policy;

	/** The nome. */
	// Nome del progetto
	private String nome;

	/** The folder id. */
	// Storage Info
	private String folderId;

	/** The last update time. */
	// Accounting
	private Date lastUpdateTime;

	/** The last update user. */
	private String lastUpdateUser;

	/** The creation time. */
	private Date creationTime;

	/** The creation user. */
	private String creationUser;

	/**
	 * Instantiates a new record.
	 */
	public RecordDV() {

	}

	/**
	 * Gets the item id.
	 *
	 * @return the item id
	 */
	public String getItemId() {
		return itemId;
	}

	/**
	 * Sets the item id.
	 *
	 * @param itemId the new item id
	 */
	public void setItemId(String itemId) {
		this.itemId = itemId;
	}

	/**
	 * Gets the record type.
	 *
	 * @return the record type
	 */
	public String getRecordType() {
		return recordType;
	}

	/**
	 * Sets the record type.
	 *
	 * @param recordType the new record type
	 */
	public void setRecordType(String recordType) {
		this.recordType = recordType;
	}

	/**
	 * Gets the version.
	 *
	 * @return the version
	 */
	public String getVersion() {
		return version;
	}

	/**
	 * Sets the version.
	 *
	 * @param version the new version
	 */
	public void setVersion(String version) {
		this.version = version;
	}

	/**
	 * Gets the licenza ID.
	 *
	 * @return the licenza ID
	 */
	public String getLicenzaID() {
		return licenzaID;
	}

	/**
	 * Sets the licenza ID.
	 *
	 * @param licenzaID the new licenza ID
	 */
	public void setLicenzaID(String licenzaID) {
		this.licenzaID = licenzaID;
	}

	/**
	 * Gets the accesso.
	 *
	 * @return the accesso
	 */
	public String getPolicy() {
		return policy;
	}

	/**
	 * Sets the accesso.
	 *
	 * @param policy the new policy
	 */
	public void setPolicy(String policy) {
		this.policy = policy;
	}

	/**
	 * Gets the nome.
	 *
	 * @return the nome
	 */
	public String getNome() {
		return nome;
	}

	/**
	 * Sets the nome.
	 *
	 * @param nome the new nome
	 */
	public void setNome(String nome) {
		this.nome = nome;
	}

	/**
	 * Gets the folder id.
	 *
	 * @return the folder id
	 */
	public String getFolderId() {
		return folderId;
	}

	/**
	 * Sets the folder id.
	 *
	 * @param folderId the new folder id
	 */
	public void setFolderId(String folderId) {
		this.folderId = folderId;
	}

	/**
	 * Gets the last update time.
	 *
	 * @return the last update time
	 */
	public Date getLastUpdateTime() {
		return lastUpdateTime;
	}

	/**
	 * Sets the last update time.
	 *
	 * @param date the new last update time
	 */
	public void setLastUpdateTime(Date date) {
		this.lastUpdateTime = date;
	}

	/**
	 * Gets the last update user.
	 *
	 * @return the last update user
	 */
	public String getLastUpdateUser() {
		return lastUpdateUser;
	}

	/**
	 * Sets the last update user.
	 *
	 * @param lastUpdateUser the new last update user
	 */
	public void setLastUpdateUser(String lastUpdateUser) {
		this.lastUpdateUser = lastUpdateUser;
	}

	/**
	 * Gets the creation time.
	 *
	 * @return the creation time
	 */
	public Date getCreationTime() {
		return creationTime;
	}

	/**
	 * Sets the creation time.
	 *
	 * @param creationTime the new creation time
	 */
	public void setCreationTime(Date creationTime) {
		this.creationTime = creationTime;
	}

	/**
	 * Gets the creation user.
	 *
	 * @return the creation user
	 */
	public String getCreationUser() {
		return creationUser;
	}

	/**
	 * Sets the creation user.
	 *
	 * @param creationUser the new creation user
	 */
	public void setCreationUser(String creationUser) {
		this.creationUser = creationUser;
	}

	/**
	 * To string.
	 *
	 * @return the string
	 */
	@Override
	public String toString() {
		StringBuilder builder = new StringBuilder();
		builder.append("RecordDV [itemId=");
		builder.append(itemId);
		builder.append(", recordType=");
		builder.append(recordType);
		builder.append(", version=");
		builder.append(version);
		builder.append(", licenzaID=");
		builder.append(licenzaID);
		builder.append(", policy=");
		builder.append(policy);
		builder.append(", nome=");
		builder.append(nome);
		builder.append(", folderId=");
		builder.append(folderId);
		builder.append(", lastUpdateTime=");
		builder.append(lastUpdateTime);
		builder.append(", lastUpdateUser=");
		builder.append(lastUpdateUser);
		builder.append(", creationTime=");
		builder.append(creationTime);
		builder.append(", creationUser=");
		builder.append(creationUser);
		builder.append("]");
		return builder.toString();
	}

	
}
