package org.gcube.application.geoportalcommon.shared.products.content;

import java.io.Serializable;

/**
 * The Class WorkspaceContentDV.
 *
 * @author Francesco Mangiacrapa at ISTI-CNR (francesco.mangiacrapa@isti.cnr.it)
 * 
 *         Nov 5, 2020
 */
public class WorkspaceContentDV implements Serializable {

	/**
	 * 
	 */
	private static final long serialVersionUID = -3919923007831416696L;

	/** The mimetype. */
	private String mimetype;

	/** The storage ID. */
	private String storageID;

	/** The link. */
	private String link;

	private Long id;

	private String name;

	// this field is used by GUI
	private Integer cliendId;

	/**
	 * Instantiates a new workspace content DV.
	 */
	public WorkspaceContentDV() {

	}

	/**
	 * Gets the id.
	 *
	 * @return the id
	 */
	public Long getId() {
		return id;
	}

	/**
	 * Sets the id.
	 *
	 * @param id the new id
	 */
	public void setId(Long id) {
		this.id = id;
	}

	/**
	 * Gets the mimetype.
	 *
	 * @return the mimetype
	 */
	public String getMimetype() {
		return mimetype;
	}

	/**
	 * Sets the mimetype.
	 *
	 * @param mimetype the new mimetype
	 */
	public void setMimetype(String mimetype) {
		this.mimetype = mimetype;
	}

	/**
	 * Gets the storage ID.
	 *
	 * @return the storage ID
	 */
	public String getStorageID() {
		return storageID;
	}

	/**
	 * Sets the storage ID.
	 *
	 * @param storageID the new storage ID
	 */
	public void setStorageID(String storageID) {
		this.storageID = storageID;
	}

	/**
	 * Gets the link.
	 *
	 * @return the link
	 */
	public String getLink() {
		return link;
	}

	/**
	 * Sets the link.
	 *
	 * @param link the new link
	 */
	public void setLink(String link) {
		this.link = link;
	}

	/**
	 * Gets the name.
	 *
	 * @return the name
	 */
	public String getName() {
		return name;
	}

	/**
	 * Sets the name.
	 *
	 * @param name the new name
	 */
	public void setName(String name) {
		this.name = name;
	}

	/**
	 * Gets the cliend id.
	 *
	 * @return the cliend id
	 */
	public Integer getCliendId() {
		return cliendId;
	}

	/**
	 * Sets the cliend id.
	 *
	 * @param cliendId the new cliend id
	 */
	public void setCliendId(Integer cliendId) {
		this.cliendId = cliendId;
	}

	/**
	 * To string.
	 *
	 * @return the string
	 */
	@Override
	public String toString() {
		StringBuilder builder = new StringBuilder();
		builder.append("WorkspaceContentDV [mimetype=");
		builder.append(mimetype);
		builder.append(", storageID=");
		builder.append(storageID);
		builder.append(", link=");
		builder.append(link);
		builder.append(", id=");
		builder.append(id);
		builder.append(", name=");
		builder.append(name);
		builder.append("]");
		return builder.toString();
	}

}
