/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.geoportal.client.utils;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import org.apache.commons.io.IOUtils;
import org.bson.Document;
import org.gcube.application.geoportal.client.utils.Serialization;
import org.gcube.application.geoportal.common.model.rest.QueryRequest;
import org.gcube.application.geoportal.common.utils.Files;

public class Queries {
    public static QueryRequest parse(String json) throws IOException {
        Document queryDocument = Document.parse((String)json);
        QueryRequest req = new QueryRequest();
        if (queryDocument.containsKey((Object)"ordering")) {
            req.setOrdering(Serialization.read(((Document)queryDocument.get((Object)"ordering")).toJson(), QueryRequest.OrderedRequest.class));
        }
        if (queryDocument.containsKey((Object)"paging")) {
            req.setPaging(Serialization.read(((Document)queryDocument.get((Object)"paging")).toJson(), QueryRequest.PagedRequest.class));
        }
        req.setProjection((Document)queryDocument.get((Object)"projection", Document.class));
        req.setFilter((Document)queryDocument.get((Object)"filter", Document.class));
        return req;
    }

    public static QueryRequest readPath(String jsonFilePath) throws IOException {
        return Queries.parse(Files.readFileAsString((String)jsonFilePath, (Charset)Charset.defaultCharset()));
    }

    public static QueryRequest readFile(File jsonFile) throws IOException {
        return Queries.parse(Files.readFileAsString((String)jsonFile.getAbsolutePath(), (Charset)Charset.defaultCharset()));
    }

    public static QueryRequest read(InputStream is) throws IOException {
        return Queries.parse(IOUtils.toString((InputStream)is));
    }
}

