/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.geoportal.client.utils;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import org.gcube.application.geoportal.client.utils.Serialization;
import org.gcube.application.geoportal.common.model.legacy.AbstractRelazione;
import org.gcube.application.geoportal.common.model.legacy.AssociatedContent;
import org.gcube.application.geoportal.common.model.legacy.Concessione;
import org.gcube.application.geoportal.common.model.legacy.LayerConcessione;
import org.gcube.application.geoportal.common.model.legacy.PersistedContent;
import org.gcube.application.geoportal.common.model.legacy.RelazioneScavo;
import org.gcube.application.geoportal.common.model.legacy.WorkspaceContent;
import org.gcube.application.geoportal.common.model.rest.AddSectionToConcessioneRequest;
import org.gcube.application.geoportal.common.rest.MongoConcessioni;
import org.gcube.application.geoportal.common.utils.StorageUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConcessioniUtils {
    private static final Logger log = LoggerFactory.getLogger(ConcessioniUtils.class);

    public static final Concessione clone(MongoConcessioni client, String toCloneId) throws Exception {
        int i;
        StorageUtils storage = new StorageUtils();
        log.info("Cloning {}", (Object)toCloneId);
        Concessione src = client.getById(toCloneId);
        Concessione copied = Serialization.read(Serialization.write(src), Concessione.class);
        copied.setMongo_id(null);
        copied.setLastUpdateTime(null);
        copied.setLastUpdateUser(null);
        copied.setFolderId(null);
        copied.setReport(null);
        copied.setCreationTime(null);
        copied.setCreationUser(null);
        copied.setId(0L);
        copied.setVersion("1.0.0");
        copied.setRelazioneScavo(null);
        copied.setAbstractRelazione(null);
        copied.setPosizionamentoScavo(null);
        copied.setImmaginiRappresentative(null);
        copied.setPianteFineScavo(null);
        copied = client.createNew(copied);
        copied.setRelazioneScavo(ConcessioniUtils.clean(src.getRelazioneScavo()));
        copied = client.replace(copied);
        AddSectionToConcessioneRequest req = ConcessioniUtils.asCopyRequest(src.getRelazioneScavo(), storage);
        if (req.getStreams() != null && !req.getStreams().isEmpty()) {
            copied = client.registerFileSet(copied.getMongo_id(), req);
        }
        copied.setAbstractRelazione(ConcessioniUtils.clean(src.getAbstractRelazione()));
        copied = client.replace(copied);
        req = ConcessioniUtils.asCopyRequest(src.getAbstractRelazione(), storage);
        if (req.getStreams() != null && !req.getStreams().isEmpty()) {
            copied = client.registerFileSet(copied.getMongo_id(), req);
        }
        copied.setPosizionamentoScavo(ConcessioniUtils.clean(src.getPosizionamentoScavo()));
        copied = client.replace(copied);
        req = ConcessioniUtils.asCopyRequest(src.getPosizionamentoScavo(), storage);
        if (req.getStreams() != null && !req.getStreams().isEmpty()) {
            copied = client.registerFileSet(copied.getMongo_id(), req);
        }
        if (src.getImmaginiRappresentative() != null && src.getImmaginiRappresentative().size() > 0) {
            copied.setImmaginiRappresentative(new ArrayList());
            for (i = 0; i < src.getImmaginiRappresentative().size(); ++i) {
                copied.getImmaginiRappresentative().add(ConcessioniUtils.clean((AssociatedContent)src.getImmaginiRappresentative().get(i)));
                copied = client.replace(copied);
                req = ConcessioniUtils.asCopyRequest((AssociatedContent)src.getImmaginiRappresentative().get(i), storage);
                req.setDestinationPath(Concessione.Paths.imgByIndex((int)i));
                if (req.getStreams() == null || req.getStreams().isEmpty()) continue;
                copied = client.registerFileSet(copied.getMongo_id(), req);
            }
        }
        if (src.getPianteFineScavo() != null && src.getPianteFineScavo().size() > 0) {
            copied.setPianteFineScavo(new ArrayList());
            for (i = 0; i < src.getPianteFineScavo().size(); ++i) {
                copied.getPianteFineScavo().add(ConcessioniUtils.clean((AssociatedContent)src.getPianteFineScavo().get(i)));
                copied = client.replace(copied);
                req = ConcessioniUtils.asCopyRequest((AssociatedContent)src.getPianteFineScavo().get(i), storage);
                req.setDestinationPath(Concessione.Paths.imgByIndex((int)i));
                if (req.getStreams() == null || req.getStreams().isEmpty()) continue;
                copied = client.registerFileSet(copied.getMongo_id(), req);
            }
        }
        log.info("Cloned {} into {} ", (Object)src.getMongo_id(), (Object)copied.getMongo_id());
        return copied;
    }

    private static <T extends AssociatedContent> AddSectionToConcessioneRequest asCopyRequest(T content, StorageUtils storage) throws IOException {
        AddSectionToConcessioneRequest request = new AddSectionToConcessioneRequest();
        request.setStreams(new ArrayList());
        if (content.getActualContent() != null) {
            for (PersistedContent persistedContent : content.getActualContent()) {
                if (!(persistedContent instanceof WorkspaceContent)) continue;
                WorkspaceContent wc = (WorkspaceContent)persistedContent;
                request.getStreams().add(storage.putOntoStorage(new URL(wc.getLink()).openStream(), wc.getName()));
            }
        }
        String path = null;
        if (content instanceof LayerConcessione) {
            path = "posizionamentoScavo";
        } else if (content instanceof RelazioneScavo) {
            path = "relazione";
        } else if (content instanceof AbstractRelazione) {
            path = "abstract_relazione";
        }
        request.setDestinationPath(path);
        return request;
    }

    private static <T extends AssociatedContent> T clean(T content) throws IOException {
        AssociatedContent toReturn = (AssociatedContent)Serialization.read(Serialization.write(content), content.getClass());
        toReturn.setMongo_id(null);
        toReturn.setCreationTime(null);
        toReturn.setId(0L);
        toReturn.setActualContent(new ArrayList());
        if (content instanceof LayerConcessione) {
            ((LayerConcessione)toReturn).setLayerName(null);
            ((LayerConcessione)toReturn).setLayerID(null);
            ((LayerConcessione)toReturn).setBbox(null);
            ((LayerConcessione)toReturn).setLayerUUID(null);
            ((LayerConcessione)toReturn).setWorkspace(null);
            ((LayerConcessione)toReturn).setWmsLink(null);
        }
        return (T)toReturn;
    }
}

