/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.geoportal.client;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.beans.ConstructorProperties;
import java.io.IOException;
import java.io.InputStream;
import java.rmi.RemoteException;
import java.util.Iterator;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Response;
import lombok.NonNull;
import org.gcube.application.geoportal.client.utils.Serialization;
import org.gcube.application.geoportal.common.model.legacy.Concessione;
import org.gcube.application.geoportal.common.model.rest.AddSectionToConcessioneRequest;
import org.gcube.application.geoportal.common.model.rest.Configuration;
import org.gcube.application.geoportal.common.model.rest.QueryRequest;
import org.gcube.application.geoportal.common.rest.MongoConcessioni;
import org.gcube.common.clients.Call;
import org.gcube.common.clients.delegates.ProxyDelegate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultMongoConcessioni
implements MongoConcessioni {
    private static final Logger log = LoggerFactory.getLogger(DefaultMongoConcessioni.class);
    @NonNull
    private final ProxyDelegate<WebTarget> delegate;
    private final ObjectMapper mapper = Serialization.mapper;

    public Concessione createNew(Concessione c) throws Exception {
        log.debug("Serializing {} ", (Object)c);
        String serialized = this.mapper.writeValueAsString((Object)c);
        Call call = endpoint -> {
            Response resp = endpoint.request(new String[]{"application/json"}).post(Entity.entity((Object)serialized, (String)"application/json"));
            return DefaultMongoConcessioni.check(resp, Concessione.class);
        };
        Concessione toReturn = (Concessione)this.delegate.make(call);
        log.info("Registered {}", (Object)toReturn);
        return toReturn;
    }

    public void deleteById(String id) throws Exception {
        this.deleteById(id, false);
    }

    public void deleteById(String id, Boolean force) throws Exception {
        log.debug("Deleting by id {}", (Object)id);
        this.delegate.make(endpoint -> {
            DefaultMongoConcessioni.check(endpoint.path(id).queryParam("force", new Object[]{force}).request(new String[]{"application/json"}).delete(), null);
            log.info("Deleted by id {}", (Object)id);
            return null;
        });
    }

    public Concessione getById(String id) throws Exception {
        log.debug("Loading by id {}", (Object)id);
        Call call = endpoint -> {
            Response resp = endpoint.path(id).request(new String[]{"application/json"}).get();
            return DefaultMongoConcessioni.check(resp, Concessione.class);
        };
        Concessione toReturn = (Concessione)this.delegate.make(call);
        log.debug("Loaded {}", (Object)toReturn);
        return toReturn;
    }

    public Iterator<Concessione> getList() throws Exception {
        log.debug("Getting list");
        Call call = endpoint -> this.mapper.readerFor(Concessione.class).readValues((InputStream)endpoint.request(new String[]{"application/json"}).get(InputStream.class));
        return (Iterator)this.delegate.make(call);
    }

    public Concessione publish(String id) throws Exception {
        log.info("Publishing {} ", (Object)id);
        Call call = endpoint -> {
            Response resp = endpoint.path("publish").path(id).request(new String[]{"application/json"}).put(Entity.entity((Object)id, (String)"application/json"));
            return DefaultMongoConcessioni.check(resp, Concessione.class);
        };
        Concessione toReturn = (Concessione)this.delegate.make(call);
        log.debug("Published {}\u00a0", (Object)toReturn);
        return toReturn;
    }

    public void unPublish(String id) throws Exception {
        log.info("Publishing {} ", (Object)id);
        Call call = endpoint -> {
            Response resp = endpoint.path("publish").path(id).request(new String[]{"application/json"}).delete();
            DefaultMongoConcessioni.check(resp, null);
            return null;
        };
        this.delegate.make(call);
        log.debug("UnPublished {}\u00a0", (Object)id);
    }

    public Configuration getCurrentConfiguration() throws Exception {
        return (Configuration)this.delegate.make(webTarget -> DefaultMongoConcessioni.check(webTarget.path("configuration").request(new String[]{"application/json"}).get(), Configuration.class));
    }

    public Iterator<Concessione> search(String s) throws Exception {
        log.debug("Searching for {}", (Object)s);
        Call call = endpoint -> {
            Response resp = endpoint.path("search").request(new String[]{"application/json"}).post(Entity.entity((Object)s, (String)"application/json"));
            return DefaultMongoConcessioni.checkCollection(resp, Concessione.class);
        };
        return (Iterator)this.delegate.make(call);
    }

    public Iterator<Concessione> query(QueryRequest queryRequest) throws Exception {
        log.debug("Querying for {}", (Object)queryRequest);
        return this.queryForType(queryRequest, Concessione.class);
    }

    public String queryForJSON(QueryRequest queryRequest) throws Exception {
        return null;
    }

    public <T> Iterator<T> queryForType(QueryRequest queryRequest, Class<T> aClass) throws Exception {
        log.debug("Querying for {}", (Object)queryRequest);
        Call call = endpoint -> {
            Response resp = endpoint.path("query").request(new String[]{"application/json"}).post(Entity.entity((Object)queryRequest, (String)"application/json"));
            return DefaultMongoConcessioni.checkCollection(resp, aClass);
        };
        return (Iterator)this.delegate.make(call);
    }

    public Concessione registerFileSet(String id, AddSectionToConcessioneRequest request) throws Exception {
        log.info("Registering {} in {}", (Object)request, (Object)id);
        request.validate();
        Call call = endpoint -> {
            Response resp = endpoint.path("registerFiles").path(id).request(new String[]{"application/json"}).post(Entity.entity((Object)this.mapper.writeValueAsString((Object)request), (String)"application/json"));
            return DefaultMongoConcessioni.check(resp, Concessione.class);
        };
        Concessione toReturn = (Concessione)this.delegate.make(call);
        log.debug("Registered Fileset {} result is {}\u00a0", (Object)request, (Object)toReturn);
        return toReturn;
    }

    public Concessione cleanFileSet(String id, String path) throws Exception {
        log.info("Cleaning Fileset at {} in {}", (Object)path, (Object)id);
        Call call = endpoint -> {
            Response resp = endpoint.path("deleteFiles").path(id).request(new String[]{"application/json"}).post(Entity.entity((Object)path, (String)"application/json"));
            return DefaultMongoConcessioni.check(resp, Concessione.class);
        };
        Concessione toReturn = (Concessione)this.delegate.make(call);
        log.debug("Cleaned path {} result {}\u00a0", (Object)path, (Object)toReturn);
        return toReturn;
    }

    public Concessione update(String id, String jsonUpdate) throws Exception {
        log.info("Updating {} ", (Object)id);
        log.debug("JSON is {} ", (Object)jsonUpdate);
        Call call = endpoint -> {
            Response resp = endpoint.path(id).request(new String[]{"application/json"}).put(Entity.entity((Object)jsonUpdate, (String)"application/json"));
            return DefaultMongoConcessioni.check(resp, Concessione.class);
        };
        Concessione toReturn = (Concessione)this.delegate.make(call);
        log.debug("Updated {} is {} ", (Object)id, (Object)toReturn);
        return toReturn;
    }

    public Concessione replace(Concessione replacement) throws Exception {
        log.info("Replacing {}", (Object)replacement);
        Call call = endpoint -> {
            Response resp = endpoint.request(new String[]{"application/json"}).put(Entity.entity((Object)this.mapper.writeValueAsString((Object)replacement), (String)"application/json"));
            return DefaultMongoConcessioni.check(resp, Concessione.class);
        };
        Concessione toReturn = (Concessione)this.delegate.make(call);
        log.debug("Reloaded {}\u00a0", (Object)toReturn);
        return toReturn;
    }

    protected static <T> T check(Response resp, Class<T> clazz) throws IOException {
        String resString = (String)resp.readEntity(String.class);
        if (resp.getStatus() < 200 || resp.getStatus() >= 300) {
            throw new RemoteException("RESP STATUS IS " + resp.getStatus() + ". Message : " + resString);
        }
        System.out.println("Resp String is " + resString);
        if (clazz != null) {
            return Serialization.read(resString, clazz);
        }
        return null;
    }

    protected static <T> Iterator<T> checkCollection(Response resp, Class<T> clazz) throws IOException {
        if (resp.getStatus() < 200 || resp.getStatus() >= 300) {
            throw new RemoteException("RESP STATUS IS " + resp.getStatus() + ". Message : " + (String)resp.readEntity(String.class));
        }
        if (clazz != null) {
            return Serialization.readCollection((InputStream)resp.getEntity(), clazz);
        }
        return null;
    }

    @ConstructorProperties(value={"delegate"})
    public DefaultMongoConcessioni(@NonNull ProxyDelegate<WebTarget> delegate) {
        if (delegate == null) {
            throw new NullPointerException("delegate");
        }
        this.delegate = delegate;
    }
}

