/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.geoportal.client.utils;

import java.io.FileNotFoundException;
import java.util.ArrayList;
import org.gcube.application.geoportal.common.model.legacy.InputStreamDescriptor;
import org.gcube.application.geoportal.common.model.rest.AddSectionToConcessioneRequest;
import org.gcube.application.geoportal.common.rest.TempFile;
import org.gcube.application.geoportal.common.utils.StorageUtils;
import org.gcube.contentmanagement.blobstorage.transport.backend.RemoteBackendException;

public class FileSets {
    public static RequestBuilder build(String path) {
        return new RequestBuilder().setPath(path);
    }

    public static RequestBuilder build(String path, TempFile ... files) {
        return new RequestBuilder().setPath(path).add(files);
    }

    public static TempFile asTemp(StorageUtils storage, InputStreamDescriptor descriptor) throws RemoteBackendException, FileNotFoundException {
        return storage.putOntoStorage(descriptor.getStream(), descriptor.getFilename());
    }

    public static TempFile[] asTemp(StorageUtils storage, InputStreamDescriptor ... descriptors) throws RemoteBackendException, FileNotFoundException {
        ArrayList<TempFile> toReturn = new ArrayList<TempFile>();
        for (InputStreamDescriptor desc : descriptors) {
            toReturn.add(storage.putOntoStorage(desc.getStream(), desc.getFilename()));
        }
        return toReturn.toArray(new TempFile[toReturn.size()]);
    }

    public static class RequestBuilder {
        AddSectionToConcessioneRequest theRequest = new AddSectionToConcessioneRequest();

        public RequestBuilder add(TempFile ... f) {
            if (this.theRequest.getStreams() == null) {
                this.theRequest.setStreams(new ArrayList());
            }
            for (TempFile temp : f) {
                this.theRequest.getStreams().add(temp);
            }
            return this;
        }

        public RequestBuilder add(TempFile f) {
            if (this.theRequest.getStreams() == null) {
                this.theRequest.setStreams(new ArrayList());
            }
            this.theRequest.getStreams().add(f);
            return this;
        }

        public RequestBuilder setPath(String path) {
            this.theRequest.setDestinationPath(path);
            return this;
        }

        public AddSectionToConcessioneRequest getTheRequest() {
            return this.theRequest;
        }
    }
}

