/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.reporting.component;

import java.io.Serializable;
import java.util.List;
import org.gcube.application.reporting.component.AbstractComponent;
import org.gcube.application.reporting.component.ReportComponent;
import org.gcube.application.reporting.component.type.ReportComponentType;
import org.gcube.portlets.d4sreporting.common.shared.BasicComponent;
import org.gcube.portlets.d4sreporting.common.shared.ComponentType;

public class Heading
extends AbstractComponent {
    private int level;
    private String content;
    private boolean isReadOnly;
    private ComponentType modelType;

    public Heading(int level, String content, boolean isReadonly) {
        this.level = level;
        this.content = content;
        this.isReadOnly = isReadonly;
    }

    public int getLevel() {
        return this.level;
    }

    public boolean isReadOnly() {
        return this.isReadOnly;
    }

    public ComponentType getModelType() {
        return this.modelType;
    }

    @Override
    public ReportComponentType getType() {
        return ReportComponentType.HEADING;
    }

    @Override
    public boolean hasChildren() {
        return false;
    }

    @Override
    public List<ReportComponent> getChildren() {
        return null;
    }

    @Override
    public String getStringValue() {
        return this.content;
    }

    @Override
    public BasicComponent getModelComponent() {
        switch (this.level) {
            case 1: {
                this.modelType = ComponentType.HEADING_1;
                break;
            }
            case 2: {
                this.modelType = ComponentType.HEADING_2;
                break;
            }
            case 3: {
                this.modelType = ComponentType.HEADING_3;
                break;
            }
            case 4: {
                this.modelType = ComponentType.HEADING_4;
                break;
            }
            case 5: {
                this.modelType = ComponentType.HEADING_5;
                break;
            }
            default: {
                throw new IllegalArgumentException("Only heading level between 1 and 5 are supported");
            }
        }
        BasicComponent bc = new BasicComponent(0, 0, 700, 35, 1, this.modelType, "", (Serializable)((Object)this.content), false, this.isReadOnly, this.convertProperties());
        bc.setIdInBasket(this.getId());
        return bc;
    }
}

