/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.spd.gbifplugin.capabilities;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.data.spd.gbifplugin.search.OccurrenceSearch;
import org.gcube.data.spd.model.Condition;
import org.gcube.data.spd.model.Conditions;
import org.gcube.data.spd.model.exceptions.StreamBlockingException;
import org.gcube.data.spd.model.exceptions.StreamException;
import org.gcube.data.spd.model.exceptions.StreamNonBlockingException;
import org.gcube.data.spd.model.products.OccurrencePoint;
import org.gcube.data.spd.plugin.fwk.capabilities.OccurrencesCapability;
import org.gcube.data.spd.plugin.fwk.writers.ClosableWriter;
import org.gcube.data.spd.plugin.fwk.writers.ObjectWriter;

public class OccurrencesCapabilityImpl
extends OccurrencesCapability {
    private static GCUBELog logger = new GCUBELog(OccurrencesCapabilityImpl.class);
    private String baseUrl;

    public OccurrencesCapabilityImpl(String baseUrl) {
        this.baseUrl = baseUrl;
    }

    public Set<Conditions> getSupportedProperties() {
        return new HashSet<Conditions>(){
            {
                this.add(Conditions.DATE);
                this.add(Conditions.COORDINATE);
            }
        };
    }

    public void searchByScientificName(String word, ObjectWriter<OccurrencePoint> writer, Condition ... properties) {
        try {
            new OccurrenceSearch(this.baseUrl).search(writer, word, 200, properties);
        }
        catch (Exception e) {
            logger.debug((Object)"search occurrences by ScientificName failed", (Throwable)e);
        }
    }

    /*
     * Unable to fully structure code
     */
    public void getOccurrencesByProductKeys(ClosableWriter<OccurrencePoint> writer, Iterator<String> keys) {
        occSearch = null;
        try {
            occSearch = new OccurrenceSearch(this.baseUrl);
            if (true) ** GOTO lbl19
        }
        catch (Exception e) {
            OccurrencesCapabilityImpl.logger.error((Object)"error contacting gbif server");
            writer.write((StreamException)new StreamBlockingException("GBIF"));
            return;
        }
        do {
            key = keys.next();
            try {
                occSearch.searchByKey((ObjectWriter<OccurrencePoint>)writer, key, 200);
            }
            catch (Exception e) {
                OccurrencesCapabilityImpl.logger.warn((Object)("error retrieving key " + key), (Throwable)e);
                writer.write((StreamException)new StreamNonBlockingException("GBIF", key));
            }
lbl19:
            // 3 sources

        } while (keys.hasNext());
        writer.close();
    }

    /*
     * Unable to fully structure code
     */
    public void getOccurrencesByIds(ClosableWriter<OccurrencePoint> writer, Iterator<String> ids) {
        occSearch = null;
        try {
            occSearch = new OccurrenceSearch(this.baseUrl);
            if (true) ** GOTO lbl23
        }
        catch (Exception e) {
            OccurrencesCapabilityImpl.logger.error((Object)"error contacting gbif server");
            writer.write((StreamException)new StreamBlockingException("GBIF"));
            return;
        }
        do {
            id = ids.next();
            try {
                if (!writer.isAlive()) {
                    OccurrencesCapabilityImpl.logger.trace((Object)"the writer is closed");
                    return;
                }
                writer.write((Object)occSearch.searchById(id));
            }
            catch (Exception e) {
                OccurrencesCapabilityImpl.logger.warn((Object)("error retrieving id " + id), (Throwable)e);
                writer.write((StreamException)new StreamNonBlockingException("GBIF", id));
            }
lbl23:
            // 3 sources

        } while (ids.hasNext());
        writer.close();
    }
}

