/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.spd.gbifplugin.search.query;

import java.util.Iterator;
import java.util.Map;
import lombok.NonNull;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.data.spd.gbifplugin.search.query.MappingUtils;
import org.gcube.data.spd.gbifplugin.search.query.PagedQueryObject;

public abstract class PagedQueryIterator<T>
implements Iterator<T> {
    protected GCUBELog log = new GCUBELog(PagedQueryIterator.class);
    @NonNull
    private PagedQueryObject pagedQuery;
    Map<String, Object> mapping;
    Iterator<Map<String, Object>> resultIterator;
    Map<String, Object> actualObject = null;
    Long start = null;
    Long parsingStart = null;

    public PagedQueryIterator(@NonNull PagedQueryObject pagedQuery) {
        if (pagedQuery == null) {
            throw new NullPointerException("pagedQuery");
        }
        this.pagedQuery = pagedQuery;
    }

    protected abstract T getObject(Map<String, Object> var1) throws Exception;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean hasNext() {
        try {
            if (this.resultIterator == null) {
                String query = this.pagedQuery.buildNext();
                this.start = System.currentTimeMillis();
                this.mapping = MappingUtils.getObjectMapping(query);
                this.parsingStart = System.currentTimeMillis();
                this.log.trace((Object)("[Benchmark] got Elements with query " + query + " and took " + (this.parsingStart - this.start)));
                this.resultIterator = ((Iterable)this.mapping.get("results")).iterator();
            }
            if (this.resultIterator.hasNext()) {
                this.actualObject = this.resultIterator.next();
                if (!this.useIt(this.actualObject)) return this.hasNext();
                return true;
            }
            this.log.trace((Object)("[Benchmark] page retrieved and parsed in " + (System.currentTimeMillis() - this.start)));
            if (((Boolean)this.mapping.get("endOfRecords")).booleanValue()) {
                this.log.trace((Object)"is end of records, no next element");
                return false;
            }
            this.resultIterator = null;
            return this.hasNext();
        }
        catch (Exception e) {
            this.log.error((Object)"error computing hasNext", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    @Override
    public T next() {
        try {
            return this.getObject(this.actualObject);
        }
        catch (Exception e) {
            this.log.error((Object)"error computing next", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    protected boolean useIt(Map<String, Object> mappedObject) {
        return true;
    }

    @Override
    public void remove() {
        this.resultIterator = null;
    }
}

