/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.spd.gbifplugin.search;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.events.XMLEvent;
import org.gcube.data.spd.model.Condition;
import org.gcube.data.spd.model.Coordinate;

public class Utils {
    protected static String elaborateProps(Condition[] properties) throws Exception {
        StringBuilder props = new StringBuilder();
        block4: for (Condition prop : properties) {
            switch (prop.getType()) {
                case COORDINATE: {
                    Coordinate coord = (Coordinate)prop.getValue();
                    props.append(Utils.getCoordinateAsString(coord, prop));
                    continue block4;
                }
                case DATE: {
                    Calendar date = (Calendar)prop.getValue();
                    props.append(Utils.getDateAsString(date, prop));
                }
            }
        }
        return props.toString();
    }

    protected static String elaborateProductsKey(String id) {
        String[] splitString = id.split("\\|\\|");
        String toReturn = "scientificname=" + splitString[0] + "&dataproviderkey=" + splitString[1] + "&dataresourcekey=" + splitString[2] + "&taxonconceptkey=" + splitString[3];
        if (splitString.length > 4) {
            toReturn = toReturn + splitString[4];
        }
        return toReturn;
    }

    protected static String createProductsKey(String scientificName, String dataProviderKey, String dataResourceKey, String taxonConceptKey, String properties) {
        return scientificName + "||" + dataProviderKey + "||" + dataResourceKey + "||" + taxonConceptKey + "||" + properties;
    }

    protected static boolean checkStartElement(XMLEvent event, String tagName) {
        return event.getEventType() == 1 && event.asStartElement().getName().getLocalPart().equals(tagName);
    }

    protected static boolean checkEndElement(XMLEvent event, String tagName) {
        return event.getEventType() == 2 && event.asEndElement().getName().getLocalPart().equals(tagName);
    }

    protected static String readCharacters(XMLEventReader eventReader) throws Exception {
        String characters = "";
        XMLEvent event = eventReader.nextEvent();
        while (eventReader.hasNext() && event.isCharacters()) {
            characters = characters + event.asCharacters().getData() + " ";
            event = eventReader.nextEvent();
        }
        return characters.trim();
    }

    public static String getCoordinateAsString(Coordinate coordinate, Condition prop) {
        StringBuilder props = new StringBuilder();
        switch (prop.getOp()) {
            case EQ: {
                props.append("&minlatitude=" + coordinate.getLatitude());
                props.append("&");
                props.append("minlongitude=" + coordinate.getLongitude());
                props.append("&maxlatitude=" + coordinate.getLatitude());
                props.append("&");
                props.append("maxlongitude=" + coordinate.getLongitude());
                break;
            }
            case GT: {
                props.append("&minlatitude=" + (coordinate.getLatitude() + 0.01));
                props.append("&");
                props.append("minlongitude=" + (coordinate.getLongitude() + 0.01));
                break;
            }
            case GE: {
                props.append("&minlatitude=" + coordinate.getLatitude());
                props.append("&");
                props.append("minlongitude=" + coordinate.getLongitude());
                break;
            }
            case LT: {
                props.append("&maxlatitude=" + (coordinate.getLatitude() - 0.01));
                props.append("&");
                props.append("maxlongitude=" + (coordinate.getLatitude() - 0.01));
                break;
            }
            case LE: {
                props.append("&maxlatitude=" + coordinate.getLatitude());
                props.append("&");
                props.append("maxlongitude=" + coordinate.getLongitude());
                break;
            }
        }
        return props.toString();
    }

    public static String getDateAsString(Calendar date, Condition prop) {
        StringBuilder props = new StringBuilder();
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        Calendar newDate = date;
        switch (prop.getOp()) {
            case EQ: {
                props.append("&startdate=" + dateFormat.format(date.getTime()));
                props.append("&enddate=" + dateFormat.format(date.getTime()));
                break;
            }
            case GT: {
                newDate.add(5, -1);
                props.append("&startdate=" + dateFormat.format(date.getTime()));
                break;
            }
            case GE: {
                props.append("&startdate=" + dateFormat.format(date.getTime()));
                break;
            }
            case LT: {
                newDate.add(5, 1);
                props.append("&enddate=" + dateFormat.format(newDate.getTime()));
                break;
            }
            case LE: {
                props.append("&enddate=" + dateFormat.format(date.getTime()));
                break;
            }
        }
        return props.toString();
    }
}

