/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.enm.service.plugins.comps;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.gcube.application.enm.common.xml.logs.ExperimentLogs;
import org.gcube.application.enm.common.xml.logs.LogType;
import org.gcube.application.enm.common.xml.request.ExperimentRequest;
import org.gcube.application.enm.common.xml.results.ExperimentResults;
import org.gcube.application.enm.common.xml.results.ResultType;
import org.gcube.application.enm.common.xml.status.ExperimentStatus;
import org.gcube.application.enm.common.xml.status.StatusType;
import org.gcube.application.enm.service.ExecutionResource;
import org.gcube.application.enm.service.ExperimentUtils;
import org.gcube.application.enm.service.GenericJob;
import org.gcube.application.enm.service.concurrent.JobMonitor;
import org.gcube.application.enm.service.conn.JobUpdate;
import org.gcube.application.enm.service.conn.StorageClientUtil;
import org.gcube.application.enm.service.plugins.comps.COMPsExecutionResource;
import org.gcube.application.enm.service.util.XmlHelper;
import org.gcube.contentmanagement.blobstorage.service.IClient;

public class COMPSsJob
extends GenericJob {
    private static final int INITIALIZATION = -1;
    private static final int SUPERVISION = 0;
    private static final int FINALIZATION = 1;

    public COMPSsJob(UUID uuid, ExperimentRequest request) {
        super(uuid, request);
    }

    public COMPSsJob(UUID uuid, ExperimentRequest request, ExperimentStatus status, ExperimentResults results, ExperimentLogs logs) {
        super(uuid, request, status, results, logs);
    }

    @Override
    public ExecutionResource getExecutionResource() {
        return new COMPsExecutionResource();
    }

    @Override
    public String call() throws Exception {
        ExecutionResource execRes = this.getExecutionResource();
        if (this.isCanceled()) {
            for (String jobIdItem : this.currentJobIds()) {
                execRes.cancelExperiment(this.uuid, jobIdItem);
                this.logger.trace((Object)("Job '" + this.uuid + "' with local id '" + jobIdItem + "' was cancelled"));
            }
            this.status.setStatus(StatusType.CANCELLED);
            this.status.setDescription("The experiment was cancelled by the user");
            this.status.setCompletenessPercentage(new BigDecimal(0));
            this.status.setEndDate(XmlHelper.now());
            JobMonitor.get().updateJob(this, new JobUpdate().status(true).results(false).logs(false));
            this.logger.trace((Object)("Job '" + this.uuid + "' was cancelled"));
        } else {
            switch (this.currentStep()) {
                case -1: {
                    String jobId = execRes.sumbitExperiment(this.uuid, this.request);
                    this.next(0, jobId);
                    JobMonitor.get().schedulePendingJob(this);
                    this.logger.trace((Object)("Job '" + this.uuid.toString() + "' was successfully " + "submitted with local id '" + jobId + "'"));
                    break;
                }
                case 1: {
                    String id;
                    for (String jobIdItem : this.currentJobIds()) {
                        ExperimentResults jobResults = execRes.getResults(this.uuid, jobIdItem);
                        for (ResultType result : jobResults.getResult()) {
                            this.results.getResult().add(result);
                        }
                        ExperimentLogs jobLogs = execRes.getLogs(this.uuid, jobIdItem);
                        for (LogType log : jobLogs.getLog()) {
                            this.logs.getLog().add(log);
                        }
                    }
                    IClient storageClient = StorageClientUtil.client();
                    for (ResultType result : this.results.getResult()) {
                        if (!result.isRemote()) continue;
                        id = execRes.getResultAsFile(result, storageClient, this.request.getCredentials());
                        result.setOutputLocation(id);
                        result.setRemote(Boolean.valueOf(false));
                    }
                    for (LogType log : this.logs.getLog()) {
                        if (!log.isRemote()) continue;
                        id = execRes.getLogAsFile(log, storageClient, this.request.getCredentials());
                        log.setOutputLocation(id);
                        log.setRemote(Boolean.valueOf(false));
                    }
                    for (String jobIdItem : this.currentJobIds()) {
                        execRes.cleanExperimentOuput(this.uuid, jobIdItem);
                    }
                    this.status.setEndDate(XmlHelper.now());
                    JobMonitor.get().updateJob(this, new JobUpdate().status(true).results(true).logs(true));
                    this.logger.trace((Object)("Job '" + this.uuid.toString() + "' was cleared"));
                    break;
                }
                default: {
                    boolean hasFinished = true;
                    int completenessPercentage = 0;
                    String desc = "";
                    if (this.currentJobIds().size() > 0) {
                        ArrayList<StatusType> statusList = new ArrayList<StatusType>();
                        for (String jobIdItem : this.currentJobIds()) {
                            ExperimentStatus jobStatus = execRes.getStatus(this.uuid, jobIdItem);
                            if (jobStatus == null) continue;
                            hasFinished = hasFinished && ExperimentUtils.hasFinished(jobStatus);
                            completenessPercentage += jobStatus.getCompletenessPercentage().intValue();
                            desc = String.valueOf(desc) + jobIdItem + ":" + jobStatus.getDescription() + " ";
                            statusList.add(jobStatus.getStatus());
                            this.logger.trace((Object)("Job '" + this.uuid + "' with local id '" + jobIdItem + "' status: " + jobStatus.getStatus() + ", % of completeness: " + jobStatus.getCompletenessPercentage() + ", remote status: " + jobStatus.getDescription()));
                        }
                        this.status.setStatus(this.homogeneousStatus(statusList));
                        this.status.setCompletenessPercentage(new BigDecimal(completenessPercentage /= this.currentJobIds().size()));
                        this.status.setDescription(desc);
                        JobMonitor.get().updateJob(this, new JobUpdate().status(true).results(false).logs(false));
                    } else {
                        hasFinished = false;
                    }
                    if (hasFinished) {
                        this.next(1, this.currentJobIds());
                    }
                    JobMonitor.get().schedulePendingJob(this);
                }
            }
        }
        return this.uuid.toString();
    }

    public StatusType homogeneousStatus(List<StatusType> statusList) {
        StatusType status = StatusType.PENDING;
        int total = 0;
        int executing = 0;
        int finished = 0;
        for (StatusType item : statusList) {
            ++total;
            if (item.equals((Object)StatusType.FAILED) || item.equals((Object)StatusType.CANCELLED)) {
                return item;
            }
            if (item.equals((Object)StatusType.EXECUTING)) {
                ++executing;
                continue;
            }
            if (!item.equals((Object)StatusType.FINISHED)) continue;
            ++finished;
        }
        if (total == executing) {
            status = StatusType.EXECUTING;
        } else if (total == finished) {
            status = StatusType.FINISHED;
        }
        return status;
    }
}

