/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.enm.service.conn;

import org.gcube.application.enm.common.xml.request.ExperimentRequest;
import org.gcube.application.enm.common.xml.request.InstanceType;

public class InformationSystemClient {
    public static final String COMPSS_JOB_PLUGIN = "org.gcube.application.enm.service.plugins.comps.COMPSsJob";
    public static final String OMWS_JOB_PLUGIN = "org.gcube.application.enm.service.plugins.omws.OMWSJob";
    public static final String COMPSS_EXECUTION_RESOURCE_PLUGIN = "org.gcube.application.enm.service.plugins.comps.COMPsExecutionResource";

    public String getJobPluginName(ExperimentRequest request) {
        return COMPSS_JOB_PLUGIN;
    }

    public String getExecutionResourcePluginName(ExperimentRequest request) {
        return COMPSS_EXECUTION_RESOURCE_PLUGIN;
    }

    public FtpCredentials getCOMPSFtpCredentials() {
        return new FtpCredentials("bscgrid20.bsc.es", 21, "openbiotest", "openbiotest");
    }

    public COMPSsCredentials getCOMPSsCredentials() {
        return new COMPSsCredentials("https://bscgrid20.bsc.es/venusbes/factory", "openbiotest", "openbiotest", "openbiotest", "openbiotest");
    }

    public OpenModellerImage getOpenModellerImage() {
        return new OpenModellerImage(30, "openbiodebianbase", "ftp://bscgrid20.bsc.es/openbiotest/repo/Modeller.tar.gz", "openModeller");
    }

    public String getCOMPSsLayersetsAbsolutePath(String path) {
        return "/sharedDisk/openbio" + (path.startsWith("/") ? "" : "/") + path;
    }

    public VmInstance getVmInstance(InstanceType type) {
        switch (type) {
            default: 
        }
        VmInstance instance = new VmInstance(1.0, 2, 1.0, 0, 3);
        return instance;
    }

    public class COMPSsCredentials {
        private final String endpoint;
        private final String besUsername;
        private final String besPassword;
        private final String storageUsername;
        private final String storagePassword;

        public COMPSsCredentials(String endpoint, String besUsername, String besPassword, String storageUsername, String storagePassword) {
            this.endpoint = endpoint;
            this.besUsername = besUsername;
            this.besPassword = besPassword;
            this.storageUsername = storageUsername;
            this.storagePassword = storagePassword;
        }

        public final String getEndpoint() {
            return this.endpoint;
        }

        public final String getBesUsername() {
            return this.besUsername;
        }

        public final String getBesPassword() {
            return this.besPassword;
        }

        public final String getStorageUsername() {
            return this.storageUsername;
        }

        public final String getStoragePassword() {
            return this.storagePassword;
        }
    }

    public class FtpCredentials {
        private final String server;
        private int port;
        private final String username;
        private final String password;

        public FtpCredentials(String server, int port, String username, String password) {
            this.server = server;
            this.port = port;
            this.username = username;
            this.password = password;
        }

        public final String getServer() {
            return this.server;
        }

        public final int getPort() {
            return this.port;
        }

        public final String getUsername() {
            return this.username;
        }

        public final String getPassword() {
            return this.password;
        }
    }

    public class OpenModellerImage {
        private final int wallClock;
        private final String vmImage;
        private final String appLocation;
        private final String jobNamePrefix;

        public OpenModellerImage(int wallClock, String vmImage, String appLocation, String jobNamePrefix) {
            this.wallClock = wallClock;
            this.vmImage = vmImage;
            this.appLocation = appLocation;
            this.jobNamePrefix = jobNamePrefix;
        }

        public final int getWallClock() {
            return this.wallClock;
        }

        public final String getVmImage() {
            return this.vmImage;
        }

        public final String getAppLocation() {
            return this.appLocation;
        }

        public final String getJobNamePrefix() {
            return this.jobNamePrefix;
        }
    }

    public class VmInstance {
        private final double disSizeGB;
        private final int cores;
        private final double memoryGB;
        private final int minVMs;
        private final int maxVMs;

        public VmInstance(double disSizeGB, int cores, double memoryGB, int minVMs, int maxVMs) {
            this.disSizeGB = disSizeGB;
            this.cores = cores;
            this.memoryGB = memoryGB;
            this.minVMs = minVMs;
            this.maxVMs = maxVMs;
        }

        public final double getDisSizeGB() {
            return this.disSizeGB;
        }

        public final int getCores() {
            return this.cores;
        }

        public final double getMemoryGB() {
            return this.memoryGB;
        }

        public final int getMinVMs() {
            return this.minVMs;
        }

        public final int getMaxVMs() {
            return this.maxVMs;
        }
    }
}

