package org.gcube.application.enm.service.concurrent;

import org.gcube.common.core.utils.logging.GCUBELog;

/**
 * Executes when the Java virtual machine shuts down.
 * 
 * @author Erik Torres <ertorser@upv.es>
 */
public class ShutdownHook {

	protected GCUBELog logger = new GCUBELog(ShutdownHook.class);

	public ShutdownHook() {
		// Setup logging
		logger.trace("Constructor...");
	}

	public void attachShutDownHook(){
		Runtime.getRuntime().addShutdownHook(new Thread() {
			@Override
			public void run() {
				logger.trace("Executing Shutdown Hook");				
				// Shutdown scheduler
				JobScheduler.get().shutdownAndAwaitTermination();
				// Shutdown job execution pool
				JobExecutionPool.get().shutdownAndAwaitTermination();
			}
		});
		logger.trace("Shutdown Hook Attached");
	}

}
