/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.enm.service.concurrent;

import java.util.concurrent.atomic.AtomicLong;

public class FIFOEntry<E extends Comparable<? super E>>
implements Comparable<FIFOEntry<E>> {
    private static final AtomicLong seq = new AtomicLong(Long.MIN_VALUE);
    private final long seqNum = seq.getAndIncrement();
    private final E entry;

    public FIFOEntry(E entry) {
        this.entry = entry;
    }

    public E getEntry() {
        return this.entry;
    }

    @Override
    public int compareTo(FIFOEntry<E> other) {
        int res = this.entry.compareTo(other.entry);
        if (res == 0 && other.entry != this.entry) {
            res = this.seqNum < other.seqNum ? -1 : 1;
        }
        return res;
    }

    public boolean equals(Object other) {
        if (other instanceof FIFOEntry) {
            FIFOEntry fifoEntry = (FIFOEntry)other;
            try {
                return this.entry.equals(fifoEntry.entry);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }
}

