/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.cms.sdi.engine;

import it.geosolutions.geoserver.rest.HTTPUtils;
import it.geosolutions.geoserver.rest.encoder.GSAbstractStoreEncoder;
import it.geosolutions.geoserver.rest.encoder.datastore.GSPostGISDatastoreEncoder;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.gcube.application.cms.sdi.faults.SDIInteractionException;
import org.gcube.application.geoportal.common.model.rest.DatabaseConnection;
import org.gcube.data.transfer.library.DataTransferClient;
import org.gcube.spatial.data.gis.GISInterface;
import org.gcube.spatial.data.gis.is.AbstractGeoServerDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SDIManager {
    private static final Logger log = LoggerFactory.getLogger(SDIManager.class);
    public static final Pattern HOSTNAME_PATTERN = Pattern.compile("(?<=\\:\\/\\/)[^\\:]*");
    public static final Pattern PORT_PATTERN = Pattern.compile("(?<=\\:)[\\d]+");
    public static final Pattern DB_NAME_PATTERN = Pattern.compile("(?<=\\/)[^\\/]*(?=$)");
    private final GISInterface gis;
    private final DataTransferClient dtGeoServer;
    private final String geoserverHostName;
    private final AbstractGeoServerDescriptor currentGeoserver;
    private final String FALLBACK_GS_REST_INTERFACE = "/rest";

    public SDIManager() throws SDIInteractionException {
        try {
            log.debug("Initializing GIS Interface..");
            this.gis = GISInterface.get((AbstractGeoServerDescriptor[])new AbstractGeoServerDescriptor[0]);
            this.currentGeoserver = this.gis.getCurrentGeoServer();
            if (this.currentGeoserver == null) {
                throw new Exception("Unable to contact data transfer for geoserver ");
            }
            log.debug("Found geoserver descriptor " + this.currentGeoserver);
            this.geoserverHostName = new URL(this.currentGeoserver.getUrl()).getHost();
            log.debug("Contacting Data Transfer from geoserver {} ", (Object)this.geoserverHostName);
            String gsEP = "https://" + this.geoserverHostName;
            this.dtGeoServer = DataTransferClient.getInstanceByEndpoint((String)gsEP);
            if (!this.currentGeoserver.getReader().existGeoserver()) {
                String fallbackGSRestURL = this.currentGeoserver.getUrl() + "/rest";
                log.warn("Geoserver rest interface not reachable at /rest/. Going to check " + fallbackGSRestURL);
                if (!HTTPUtils.httpPing((String)fallbackGSRestURL, (String)this.currentGeoserver.getUser(), (String)this.currentGeoserver.getPassword())) {
                    throw new Exception("Geoserver rest interface not reachable at " + fallbackGSRestURL);
                }
            }
        }
        catch (Exception e) {
            log.error("SDIManager init failed: ", (Throwable)e);
            throw new SDIInteractionException("Unable to initialize SDI Manager", e);
        }
    }

    public String createWorkspace(String toCreate) throws SDIInteractionException {
        try {
            if (!this.currentGeoserver.getReader().getWorkspaceNames().contains(toCreate)) {
                log.debug("Creating workspace : " + toCreate);
                if (!this.currentGeoserver.getPublisher().createWorkspace(toCreate)) {
                    throw new SDIInteractionException("Unable to create workspace " + toCreate);
                }
            } else {
                log.debug("Workspace " + toCreate + " exists.");
            }
            return toCreate;
        }
        catch (IllegalArgumentException | MalformedURLException e) {
            throw new SDIInteractionException("Unable to create workspace " + toCreate, e);
        }
    }

    protected String createStore(GSPostGISDatastoreEncoder encoder, String workspace) throws SDIInteractionException {
        String storeName = encoder.getName();
        try {
            log.debug("Looking for datastore " + storeName + " under " + workspace);
            if (this.currentGeoserver.getReader().getDatastore(workspace, storeName) == null && !this.currentGeoserver.getDataStoreManager().create(workspace, (GSAbstractStoreEncoder)encoder)) {
                throw new SDIInteractionException("Unable to create store " + storeName + " in " + workspace);
            }
            log.debug("Store " + storeName + " exists under " + workspace);
            return storeName;
        }
        catch (IllegalArgumentException | MalformedURLException e) {
            throw new SDIInteractionException("Unable to create store " + storeName, e);
        }
    }

    protected String createStoreFromPostgisDB(String workspace, String storeName, DatabaseConnection connection) throws SDIInteractionException {
        String connectionUrl = connection.getUrl();
        Matcher hostname = HOSTNAME_PATTERN.matcher(connectionUrl);
        if (!hostname.find()) {
            throw new SDIInteractionException("Unable to get Hostname from " + connection);
        }
        Matcher port = PORT_PATTERN.matcher(connectionUrl);
        if (!port.find()) {
            throw new SDIInteractionException("Unable to get PORT from " + connection);
        }
        Matcher db = DB_NAME_PATTERN.matcher(connectionUrl);
        if (!db.find()) {
            throw new SDIInteractionException("Unable to get DB from " + connection);
        }
        GSPostGISDatastoreEncoder encoder = new GSPostGISDatastoreEncoder(storeName);
        encoder.setHost(hostname.group());
        encoder.setPort(Integer.parseInt(port.group()));
        encoder.setDatabase(db.group());
        encoder.setSchema("public");
        encoder.setUser(connection.getUser());
        encoder.setPassword(connection.getPwd());
        encoder.setLooseBBox(true);
        encoder.setDatabaseType("postgis");
        encoder.setEnabled(true);
        encoder.setFetchSize(1000);
        encoder.setValidateConnections(true);
        return this.createStore(encoder, workspace);
    }

    protected String publishStyle(File sldFile, String name) throws SDIInteractionException {
        try {
            if (!this.currentGeoserver.getReader().existsStyle(name)) {
                log.debug("Registering style " + name);
                if (!this.currentGeoserver.getPublisher().publishStyle(sldFile, name)) {
                    throw new SDIInteractionException("Unable to register style " + name);
                }
            } else {
                log.debug("Style " + name + " already existing");
            }
            return name;
        }
        catch (IllegalArgumentException | MalformedURLException e) {
            throw new SDIInteractionException("Unable to create style " + name, e);
        }
    }

    public DataTransferClient getDtGeoServer() {
        return this.dtGeoServer;
    }

    public String getGeoserverHostName() {
        return this.geoserverHostName;
    }

    public AbstractGeoServerDescriptor getCurrentGeoserver() {
        return this.currentGeoserver;
    }
}

