/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.cms.sdi.plugins;

import com.vdurmont.semver4j.Semver;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.bson.Document;
import org.gcube.application.cms.plugins.IndexerPluginInterface;
import org.gcube.application.cms.plugins.faults.IndexingException;
import org.gcube.application.cms.plugins.faults.InitializationException;
import org.gcube.application.cms.plugins.faults.InvalidPluginRequestException;
import org.gcube.application.cms.plugins.faults.InvalidProfileException;
import org.gcube.application.cms.plugins.reports.IndexDocumentReport;
import org.gcube.application.cms.plugins.reports.InitializationReport;
import org.gcube.application.cms.plugins.reports.Report;
import org.gcube.application.cms.plugins.requests.BaseRequest;
import org.gcube.application.cms.plugins.requests.IndexDocumentRequest;
import org.gcube.application.cms.sdi.engine.PostgisIndexer;
import org.gcube.application.cms.sdi.engine.PostgisTable;
import org.gcube.application.cms.sdi.engine.SDIManagerWrapper;
import org.gcube.application.cms.sdi.engine.bboxes.BBOXByCoordinatePaths;
import org.gcube.application.cms.sdi.engine.bboxes.BBOXEvaluator;
import org.gcube.application.cms.sdi.engine.bboxes.BBOXPathScanner;
import org.gcube.application.cms.sdi.faults.SDIInteractionException;
import org.gcube.application.cms.sdi.model.MappingObject;
import org.gcube.application.cms.sdi.plugins.SDIAbstractPlugin;
import org.gcube.application.cms.serialization.Serialization;
import org.gcube.application.geoportal.common.model.JSONPathWrapper;
import org.gcube.application.geoportal.common.model.configuration.Index;
import org.gcube.application.geoportal.common.model.document.Project;
import org.gcube.application.geoportal.common.model.document.filesets.sdi.GCubeSDILayer;
import org.gcube.application.geoportal.common.model.document.identification.IdentificationReference;
import org.gcube.application.geoportal.common.model.document.identification.SpatialReference;
import org.gcube.application.geoportal.common.model.plugins.PluginDescriptor;
import org.gcube.application.geoportal.common.model.rest.ConfigurationException;
import org.gcube.application.geoportal.common.model.rest.DatabaseConnection;
import org.gcube.application.geoportal.common.model.useCaseDescriptor.UseCaseDescriptor;
import org.gcube.portlets.user.uriresolvermanager.UriResolverManager;
import org.gcube.portlets.user.uriresolvermanager.resolvers.query.GeoportalResolverQueryStringBuilder;
import org.geojson.Crs;
import org.geojson.GeoJsonObject;
import org.geojson.LngLatAlt;
import org.geojson.Point;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SDIIndexerPlugin
extends SDIAbstractPlugin
implements IndexerPluginInterface {
    private static final Logger log = LoggerFactory.getLogger(SDIIndexerPlugin.class);
    static final PluginDescriptor DESCRIPTOR = new PluginDescriptor("SDI-Indexer-Plugin", "Indexer");
    static final ArrayList<BBOXEvaluator> BBOX_EVALUATORS = new ArrayList();

    public PluginDescriptor getDescriptor() {
        return DESCRIPTOR;
    }

    public InitializationReport initInContext() throws InitializationException {
        InitializationReport report = new InitializationReport();
        report.setStatus(Report.Status.OK);
        return report;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IndexDocumentReport index(IndexDocumentRequest request) throws InvalidPluginRequestException {
        log.info("Serving Indexer {} : request CallParameters {}, request Context {}: ", new Object[]{this.getDescriptor().getId(), request.getCallParameters(), request.getContext()});
        log.debug("Indexer {} : Serving Request {} ", (Object)this.getDescriptor().getId(), (Object)request);
        Project project = request.getDocument();
        UseCaseDescriptor useCaseDescriptor = request.getUseCaseDescriptor();
        Document requestArguments = request.getCallParameters();
        log.debug("requestArguments is {} ", (Object)requestArguments);
        IndexDocumentReport report = new IndexDocumentReport(request);
        try {
            List ids;
            String wkt;
            Double pointY;
            Object pointX;
            PostgisIndexer indexer = this.getIndexer(useCaseDescriptor, requestArguments);
            Document profileConfiguration = this.getConfigurationFromProfile(useCaseDescriptor).getConfiguration();
            log.debug("UseCaseDescriptor Configuration is {} ", (Object)profileConfiguration);
            JSONPathWrapper documentNavigator = new JSONPathWrapper(Serialization.write((Object)project));
            Document centroidDoc = new Document();
            if (requestArguments.containsKey((Object)"centroidRecord")) {
                centroidDoc.putAll((Map)requestArguments.get((Object)"centroidRecords", Document.class));
            }
            centroidDoc.put("projectid", (Object)project.getId());
            centroidDoc.put("displayed_project", (Object)true);
            Boolean isInternalIndex = null;
            try {
                isInternalIndex = requestArguments.getBoolean((Object)"flagInternalIndex");
                log.debug("flagInternalIndex read as {} ", (Object)isInternalIndex);
            }
            catch (Exception exception) {
                // empty catch block
            }
            log.info("flagInternalIndex is {} ", (Object)isInternalIndex);
            if (isInternalIndex != null) {
                try {
                    log.debug("Trying to generate Geoportal Gis Link...");
                    UriResolverManager uriResolverManager = new UriResolverManager("GEO");
                    GeoportalResolverQueryStringBuilder builder = new GeoportalResolverQueryStringBuilder(project.getProfileID(), project.getId());
                    builder.scope(request.getContext().getId());
                    if (isInternalIndex.booleanValue()) {
                        builder.resolverAs(GeoportalResolverQueryStringBuilder.RESOLVE_AS.PRIVATE);
                    } else {
                        builder.resolverAs(GeoportalResolverQueryStringBuilder.RESOLVE_AS.PUBLIC);
                    }
                    Map params = builder.buildQueryParameters();
                    String shortLink = uriResolverManager.getLink(params, true);
                    log.info("Geoportal GisViewer link is {} ", (Object)shortLink);
                    centroidDoc.put("geov_link", (Object)shortLink);
                }
                catch (Exception e) {
                    log.error("Error on creating the Geoportal GisViewer link for project id {}", (Object)project.getId(), (Object)e);
                }
            }
            log.debug("indexing UseCaseDescriptor {} : Evaluating Centroid... ", (Object)useCaseDescriptor.getId());
            SpatialReference reference = null;
            List refs = project.getIdentificationReferenceByType("SPATIAL REFERENCE");
            GCubeSDILayer.BBOX bbox = null;
            if (!refs.isEmpty()) {
                try {
                    reference = (SpatialReference)Serialization.convert(refs.get(0), SpatialReference.class);
                    log.debug("Using already defined spatial reference " + reference);
                    GeoJsonObject object = (GeoJsonObject)Serialization.convert((Object)reference.getGeoJson(), GeoJsonObject.class);
                    bbox = GCubeSDILayer.BBOX.fromGeoJSON((double[])object.getBbox());
                    log.info("Found declared BBOX {} ", (Object)bbox);
                    pointX = (bbox.getMaxX() + bbox.getMinX()) / 2.0;
                    pointY = (bbox.getMaxY() + bbox.getMinY()) / 2.0;
                    wkt = String.format("POINT (%1$f %2$f) ", pointX, pointY);
                    centroidDoc.put("geom", (Object)wkt);
                }
                catch (Exception e) {
                    log.info("The defined spatial reference is wrong or empty: " + reference);
                }
            }
            if (bbox == null) {
                log.info("No bbox defined in the current spatial reference going to calculate it...");
                log.debug("UseCaseDescriptor {} : Getting evaluation paths from useCaseDescriptor.. ", (Object)useCaseDescriptor.getId());
                GCubeSDILayer.BBOX toSet = null;
                for (BBOXEvaluator evaluator : BBOX_EVALUATORS) {
                    log.trace("UCD {}, Project {}. Evaluating BBOX with {}", new Object[]{useCaseDescriptor.getId(), project.getId(), evaluator});
                    try {
                        if (!evaluator.isConfigured(profileConfiguration) || (toSet = evaluator.evaluate(profileConfiguration, useCaseDescriptor, documentNavigator)) == null) continue;
                        log.info("UCD {}, Project {}. Evaluated BBOX {} with method {}", new Object[]{useCaseDescriptor.getId(), project.getId(), toSet, evaluator});
                        break;
                    }
                    catch (Throwable t) {
                        log.warn("UCD {}, Project {}. Exception with {}", new Object[]{useCaseDescriptor.getId(), project.getId(), evaluator, t});
                    }
                }
                if (toSet == null) {
                    throw new IndexingException("No BBOX has been evaluated from project");
                }
                pointX = (toSet.getMaxX() + toSet.getMinX()) / 2.0;
                pointY = (toSet.getMaxY() + toSet.getMinY()) / 2.0;
                log.info("Evaluated BBOX {} ", toSet);
                wkt = String.format("POINT (%1$f %2$f) ", pointX, pointY);
                Double pointZ = 0.0;
                centroidDoc.put("geom", (Object)wkt);
                Point point = new Point();
                point.setCoordinates(new LngLatAlt(((Double)pointX).doubleValue(), pointY.doubleValue(), pointZ.doubleValue()));
                point.setBbox(toSet.asGeoJSONArray());
                point.setCrs(new Crs());
                reference = new SpatialReference((Object)Serialization.asDocument((Object)point));
                log.info("UCD {} project {}, Setting Spatial Reference {} ", new Object[]{useCaseDescriptor.getId(), project.getId(), Serialization.write((Object)reference)});
                report.addIdentificationReference((IdentificationReference)reference);
            }
            log.info("Setting additional values to centroid from mappings ..");
            for (MappingObject m : this.getMappings(useCaseDescriptor)) {
                List foundValues = documentNavigator.getByPath(m.getPath());
                String toSetValue = null;
                if (!foundValues.isEmpty()) {
                    StringBuilder b = new StringBuilder();
                    foundValues.forEach(o -> {
                        if (o instanceof Collection) {
                            ((Collection)o).forEach(v -> b.append(v + ","));
                        } else {
                            b.append(o + ",");
                        }
                    });
                    b.deleteCharAt(b.length() - 1);
                    toSetValue = b.toString();
                }
                log.trace("Setting {} = {} in centroid doc ", (Object)m.getName(), toSetValue);
                centroidDoc.put(m.getName(), toSetValue);
            }
            log.info("Inserting Centroid {} into {} ", (Object)Serialization.write((Object)centroidDoc.toJson()), (Object)indexer);
            indexer.insert(centroidDoc);
            if (requestArguments.containsKey((Object)"_toHideIds")) {
                ids = (List)Serialization.convert((Object)requestArguments.get((Object)"_toHideIds"), List.class);
                log.info("Requested to hide centroids {} ", (Object)ids);
                indexer.updateIsVisible(false, ids);
            }
            if (requestArguments.containsKey((Object)"_toDisplayIds")) {
                ids = (List)Serialization.convert((Object)requestArguments.get((Object)"_toDisplayIds"), List.class);
                log.info("Requested to display centroids {} ", (Object)ids);
                indexer.updateIsVisible(true, ids);
            }
            report.setStatus(Report.Status.OK);
        }
        catch (SDIInteractionException e) {
            log.error("Unable to index " + request, (Throwable)e);
            report.setStatus(Report.Status.ERROR);
            report.putMessage(e.getMessage());
        }
        catch (Throwable t) {
            log.error("Unable to index " + request, t);
            report.setStatus(Report.Status.ERROR);
            report.putMessage(t.getMessage());
        }
        finally {
            return report;
        }
    }

    private List<MappingObject> getMappings(UseCaseDescriptor useCaseDescriptor) throws InvalidProfileException {
        return MappingObject.getMappingsFromUCD(useCaseDescriptor, this.getDescriptor().getId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IndexDocumentReport deindex(IndexDocumentRequest request) throws InvalidPluginRequestException {
        log.info("Serving DeIndexer {} : request CallParameters {}, request Context {}: ", new Object[]{this.getDescriptor().getId(), request.getCallParameters(), request.getContext()});
        log.debug("DeIndexer {} : Serving Request {} ", (Object)this.getDescriptor().getId(), (Object)request);
        IndexDocumentReport report = new IndexDocumentReport(request);
        try {
            PostgisIndexer indexer = this.getIndexer(request.getUseCaseDescriptor(), request.getCallParameters());
            indexer.removeByFieldValue(PostgisIndexer.StandardFields.PROJECT_ID, request.getDocument().getId());
            SpatialReference reference = new SpatialReference((Object)new Document());
            log.info("DeIndexer project {}, Setting Spatial Reference empty {} ", (Object)request.getDocument().getId(), (Object)Serialization.write((Object)reference));
            report.addIdentificationReference((IdentificationReference)reference);
        }
        catch (SDIInteractionException e) {
            log.error("Unable to index " + request, (Throwable)e);
            report.setStatus(Report.Status.ERROR);
            report.putMessage(e.getMessage());
        }
        catch (Throwable t) {
            log.error("Unable to index " + request, t);
            report.setStatus(Report.Status.ERROR);
            report.putMessage(t.getMessage());
        }
        finally {
            return report;
        }
    }

    public Index getIndex(BaseRequest request) throws ConfigurationException {
        try {
            return this.getIndexer(request.getUseCaseDescriptor(), request.getCallParameters()).getIndexConfiguration();
        }
        catch (Throwable t) {
            throw new ConfigurationException("Unable to get Postgis index for ucd " + request.getUseCaseDescriptor().getId() + " in " + request.getContext(), t);
        }
    }

    private PostgisIndexer getIndexer(UseCaseDescriptor ucd, Document params) throws ConfigurationException, SQLException, InvalidProfileException, SDIInteractionException {
        PostgisIndexer indexer = new PostgisIndexer((SDIManagerWrapper)sdiCache.getObject(), ucd, (DatabaseConnection)postgisCache.getObject());
        List<MappingObject> mappingObjects = this.getMappings(ucd);
        List<PostgisTable.Field> fields = PostgisTable.Field.fromMappings(mappingObjects);
        indexer.initIndex(params.getString((Object)"indexName"), fields, params.getString((Object)"workspace"), params.getString((Object)"indexName"));
        return indexer;
    }

    static {
        DESCRIPTOR.setDescription("SDI Indexer. Manage Centroids layers.");
        DESCRIPTOR.setVersion(new Semver("1.0.0"));
        BBOX_EVALUATORS.add(new BBOXPathScanner());
        BBOX_EVALUATORS.add(new BBOXByCoordinatePaths());
    }
}

