/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.cms.sdi.plugins;

import com.vdurmont.semver4j.Semver;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bson.Document;
import org.gcube.application.cms.implementations.utils.UserUtils;
import org.gcube.application.cms.plugins.MaterializationPlugin;
import org.gcube.application.cms.plugins.faults.InitializationException;
import org.gcube.application.cms.plugins.faults.InvalidPluginRequestException;
import org.gcube.application.cms.plugins.faults.MaterializationException;
import org.gcube.application.cms.plugins.faults.ShutDownException;
import org.gcube.application.cms.plugins.implementations.AbstractPlugin;
import org.gcube.application.cms.plugins.reports.InitializationReport;
import org.gcube.application.cms.plugins.reports.MaterializationReport;
import org.gcube.application.cms.plugins.reports.Report;
import org.gcube.application.cms.plugins.requests.MaterializationRequest;
import org.gcube.application.cms.sdi.engine.SDIManagerWrapper;
import org.gcube.application.cms.sdi.faults.SDIInteractionException;
import org.gcube.application.cms.serialization.Serialization;
import org.gcube.application.geoportal.common.model.JSONPathWrapper;
import org.gcube.application.geoportal.common.model.document.Project;
import org.gcube.application.geoportal.common.model.document.filesets.Materialization;
import org.gcube.application.geoportal.common.model.document.filesets.RegisteredFileSet;
import org.gcube.application.geoportal.common.model.document.filesets.sdi.GCubeSDILayer;
import org.gcube.application.geoportal.common.model.plugins.PluginDescriptor;
import org.gcube.application.geoportal.common.model.useCaseDescriptor.Field;
import org.gcube.application.geoportal.common.model.useCaseDescriptor.UseCaseDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SDIMaterializerPlugin
extends AbstractPlugin
implements MaterializationPlugin {
    private static final Logger log = LoggerFactory.getLogger(SDIMaterializerPlugin.class);
    private final Object $lock = new Object[0];
    Map<String, SDIManagerWrapper> sdiManagerMap = null;
    static final PluginDescriptor DESCRIPTOR = new PluginDescriptor("SDI-Default-Materializer", "Materializer");

    private SDIManagerWrapper getSDIManager() {
        String context = UserUtils.getCurrent().getContext();
        log.debug("Getting SDIManagerWrapper from cache map for context {}");
        return this.sdiManagerMap.get(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InitializationReport initInContext() throws InitializationException {
        Object object = this.$lock;
        synchronized (object) {
            InitializationReport report = new InitializationReport();
            try {
                String context = UserUtils.getCurrent().getContext();
                if (this.getSDIManager() == null) {
                    log.info("Initializing in " + context);
                    this.sdiManagerMap.put(context, new SDIManagerWrapper());
                }
                report.setStatus(Report.Status.OK);
                report.putMessage("Initialized SDI Manager in " + context + " pointing to " + this.getSDIManager().getGeoserverHostName());
            }
            catch (SDIInteractionException e) {
                throw new InitializationException("Unable to initialize SDI Manager ", (Throwable)e);
            }
            return report;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InitializationReport init() throws InitializationException {
        Object object = this.$lock;
        synchronized (object) {
            InitializationReport report = new InitializationReport();
            this.sdiManagerMap = new HashMap<String, SDIManagerWrapper>();
            report.setStatus(Report.Status.OK);
            return report;
        }
    }

    public void shutdown() throws ShutDownException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MaterializationReport materialize(MaterializationRequest request) throws MaterializationException, InvalidPluginRequestException {
        log.info("Serving Materialize {} : request CallParameters {}, request Context {}", new Object[]{this.getDescriptor().getId(), request.getCallParameters(), request.getContext()});
        log.debug("Materialize request {}", (Object)request);
        Project project = request.getDocument();
        UseCaseDescriptor useCaseDescriptor = request.getUseCaseDescriptor();
        Document requestArguments = (Document)Serialization.convert((Object)request.getCallParameters(), Document.class);
        MaterializationReport report = new MaterializationReport(request);
        try {
            Document profileConfiguration = this.getConfigurationFromProfile(useCaseDescriptor).getConfiguration();
            log.debug("UseCaseDescriptor Configuration is {} ", (Object)profileConfiguration);
            JSONPathWrapper documentNavigator = new JSONPathWrapper(project.getTheDocument().toJson());
            JSONPathWrapper schemaNavigator = new JSONPathWrapper(useCaseDescriptor.getSchema().toJson());
            for (Object fsConfigObj : (List)profileConfiguration.get((Object)"registeredFileSetPaths", List.class)) {
                log.debug("Managing {}\u00a0", fsConfigObj);
                MaterializationConfig fsConfig = (MaterializationConfig)Serialization.convert(fsConfigObj, MaterializationConfig.class);
                List matchingFieldDefinitions = schemaNavigator.getByPath(fsConfig.getSchemaField());
                if (matchingFieldDefinitions == null || matchingFieldDefinitions.isEmpty()) {
                    throw new MaterializationException("Invalid Field Definition path in configuration [NO MATCH] : " + fsConfig.getSchemaField());
                }
                if (matchingFieldDefinitions.size() > 1) {
                    throw new MaterializationException("Invalid Field Definition path in configuration [MATCHES " + matchingFieldDefinitions.size() + "] : " + fsConfig.getSchemaField());
                }
                Field f = (Field)Serialization.convert(matchingFieldDefinitions.get(0), Field.class);
                for (Object fsObject : documentNavigator.getByPath(fsConfig.getDocumentPath())) {
                    RegisteredFileSet fs = (RegisteredFileSet)Serialization.convert(fsObject, RegisteredFileSet.class);
                    log.debug("Found {} ", (Object)fs);
                    requestArguments.putIfAbsent((Object)"basePersistencePath", (Object)useCaseDescriptor.getId());
                    requestArguments.putIfAbsent((Object)"documentID", (Object)project.getId());
                    if (requestArguments.containsKey((Object)"titleField")) {
                        requestArguments.putIfAbsent((Object)"layerTitle", (Object)fs.getString((Object)requestArguments.getString((Object)"titleField")));
                    } else {
                        requestArguments.putIfAbsent((Object)"layerTitle", (Object)fs.getUUID());
                    }
                    String ws = request.getMandatory("workspace") + "_" + project.getId();
                    ws = ws.replaceAll("\\W", "_");
                    log.trace("Escaped WS will be {} ", (Object)ws);
                    requestArguments.put("workspace", (Object)ws);
                    log.info("Calling materializeLayer: fs {} - requestArguments {}", (Object)fs, (Object)requestArguments);
                    RegisteredFileSet obtained = this.getSDIManager().materializeLayer(fs, requestArguments);
                    log.debug("Obtained {} ", (Object)obtained);
                    documentNavigator.setElement("$..[?(@._uuid == '" + fs.getUUID() + "')]", (Object)obtained);
                }
            }
            String finalDocument = documentNavigator.getValueCTX().jsonString();
            log.debug("Final document after materialization is {} ", (Object)finalDocument);
            report.setResultingDocument(Document.parse((String)finalDocument));
            report.setStatus(Report.Status.OK);
        }
        catch (SDIInteractionException e) {
            log.error("Unable to materialize " + request, (Throwable)e);
            report.setStatus(Report.Status.ERROR);
            report.putMessage(e.getMessage());
        }
        catch (Throwable t) {
            log.error("Exception, Unable to materialize " + request, t);
            report.setStatus(Report.Status.ERROR);
            report.putMessage(t.getMessage());
        }
        finally {
            return report;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MaterializationReport dematerialize(MaterializationRequest request) throws MaterializationException, InvalidPluginRequestException {
        log.info("Serving DeMaterialize {} : request CallParameters {}, request Context {}: ", new Object[]{this.getDescriptor().getId(), request.getCallParameters(), request.getContext()});
        log.debug("DeMaterialize request {}", (Object)request);
        MaterializationReport report = new MaterializationReport(request);
        try {
            SDIManagerWrapper sdi = this.getSDIManager();
            JSONPathWrapper wrapper = new JSONPathWrapper(request.getDocument().getTheDocument().toJson());
            for (String s : wrapper.getMatchingPaths(request.getMandatory("fileSetPath"))) {
                log.debug("Found matching {} ", (Object)s);
                RegisteredFileSet registeredFileSet = (RegisteredFileSet)Serialization.convert(wrapper.getByPath(s).get(0), RegisteredFileSet.class);
                ArrayList toKeep = new ArrayList();
                if (registeredFileSet.getMaterializations() != null) {
                    for (Object matObj : registeredFileSet.getMaterializations()) {
                        Materialization mat = (Materialization)Serialization.convert(matObj, Materialization.class);
                        if (mat.getType().equals("gcube-sdi-layer")) {
                            log.debug("Deleting Layer {} ", (Object)mat);
                            sdi.deleteLayer((GCubeSDILayer)Serialization.convert(matObj, GCubeSDILayer.class));
                            continue;
                        }
                        toKeep.add(matObj);
                    }
                }
                registeredFileSet.put("_materializations", toKeep);
                wrapper.setElement(s, (Object)registeredFileSet);
            }
            report.setResultingDocument(Document.parse((String)wrapper.getValueCTX().jsonString()));
        }
        catch (SDIInteractionException e) {
            log.error("Unable to materialize " + request, (Throwable)e);
            report.setStatus(Report.Status.ERROR);
            report.putMessage(e.getMessage());
        }
        catch (Throwable t) {
            log.error("Unable to materialize " + request, t);
            report.setStatus(Report.Status.ERROR);
            report.putMessage(t.getMessage());
        }
        finally {
            return report;
        }
    }

    public PluginDescriptor getDescriptor() {
        return DESCRIPTOR;
    }

    static {
        DESCRIPTOR.setDescription("SDI Materializer. This plugin materialize FileSets in gCube SDI.");
        DESCRIPTOR.setVersion(new Semver("1.0.0"));
    }

    public static class MaterializationConfig {
        private String schemaField;
        private String documentPath;

        public String getSchemaField() {
            return this.schemaField;
        }

        public String getDocumentPath() {
            return this.documentPath;
        }

        public void setSchemaField(String schemaField) {
            this.schemaField = schemaField;
        }

        public void setDocumentPath(String documentPath) {
            this.documentPath = documentPath;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof MaterializationConfig)) {
                return false;
            }
            MaterializationConfig other = (MaterializationConfig)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$schemaField = this.getSchemaField();
            String other$schemaField = other.getSchemaField();
            if (this$schemaField == null ? other$schemaField != null : !this$schemaField.equals(other$schemaField)) {
                return false;
            }
            String this$documentPath = this.getDocumentPath();
            String other$documentPath = other.getDocumentPath();
            return !(this$documentPath == null ? other$documentPath != null : !this$documentPath.equals(other$documentPath));
        }

        protected boolean canEqual(Object other) {
            return other instanceof MaterializationConfig;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $schemaField = this.getSchemaField();
            result = result * 59 + ($schemaField == null ? 43 : $schemaField.hashCode());
            String $documentPath = this.getDocumentPath();
            result = result * 59 + ($documentPath == null ? 43 : $documentPath.hashCode());
            return result;
        }

        public String toString() {
            return "SDIMaterializerPlugin.MaterializationConfig(schemaField=" + this.getSchemaField() + ", documentPath=" + this.getDocumentPath() + ")";
        }
    }
}

