/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.cms.sdi.engine;

import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.NonNull;
import org.bson.Document;
import org.gcube.application.cms.sdi.engine.PostgisDBManager;
import org.gcube.application.cms.sdi.engine.PostgisDBManagerI;
import org.gcube.application.cms.sdi.engine.PostgisTable;
import org.gcube.application.cms.sdi.engine.SDIManagerWrapper;
import org.gcube.application.cms.sdi.faults.SDIInteractionException;
import org.gcube.application.cms.sdi.model.CrossReferencedLayer;
import org.gcube.application.geoportal.common.model.configuration.Index;
import org.gcube.application.geoportal.common.model.document.filesets.sdi.GCubeSDILayer;
import org.gcube.application.geoportal.common.model.rest.DatabaseConnection;
import org.gcube.application.geoportal.common.model.useCaseDescriptor.UseCaseDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PostgisIndexer {
    private static final Logger log = LoggerFactory.getLogger(PostgisIndexer.class);
    public static final String INDEX_TYPE = "GIS-CENTROIDS";
    @NonNull
    SDIManagerWrapper manager;
    @NonNull
    UseCaseDescriptor useCaseDescriptor;
    @NonNull
    DatabaseConnection connectionParameters;
    PostgisDBManagerI dbManager = null;
    PostgisTable table = null;
    GCubeSDILayer indexLayer = null;
    String indexName = null;
    private List<CrossReferencedLayer> crossReferenceableLayers = new ArrayList<CrossReferencedLayer>();
    HashMap<String, GCubeSDILayer> crossReferenced = new HashMap();

    public static void init() throws ClassNotFoundException {
        Class.forName("org.postgresql.Driver");
        Class.forName("org.postgis.DriverWrapper");
    }

    public PostgisIndexer(SDIManagerWrapper manager, UseCaseDescriptor useCaseDescriptor, DatabaseConnection postgisConnection) throws SQLException {
        log.info("POSTGIS Index for {} Connecting to {} ", (Object)useCaseDescriptor.getId(), (Object)postgisConnection);
        this.connectionParameters = postgisConnection;
        this.dbManager = new PostgisDBManager(DriverManager.getConnection(this.connectionParameters.getUrl(), this.connectionParameters.getUser(), this.connectionParameters.getPwd()));
        this.manager = manager;
        this.useCaseDescriptor = useCaseDescriptor;
    }

    public void initIndex(String indexName, List<PostgisTable.Field> customFields, String workspace, String storeName) throws SQLException, SDIInteractionException {
        log.info("Check/init index for {} ", (Object)this.useCaseDescriptor.getId());
        ArrayList<PostgisTable.Field> tableFields = new ArrayList<PostgisTable.Field>();
        tableFields.add(StandardFields.GEOM);
        tableFields.add(StandardFields.PROJECT_ID);
        tableFields.add(StandardFields.DISPLAY);
        tableFields.add(StandardFields.GEOV_LINK);
        tableFields.addAll(customFields);
        this.table = new PostgisTable(indexName, tableFields, PostgisTable.GeometryType.POINT);
        log.trace("Index Postgis Table is {} ", (Object)this.table);
        log.debug("Create if missing..");
        this.dbManager.create(this.table);
        log.debug("Checking/ registering index layer in GS ");
        this.indexName = indexName;
        this.indexLayer = this.manager.configureCentroidLayer(indexName, workspace, storeName, this.table, this.connectionParameters);
    }

    public Index getIndexConfiguration() {
        Index toReturn = new Index(INDEX_TYPE);
        toReturn.put("layer", (Object)this.indexLayer);
        toReturn.put("indexName", (Object)this.indexName);
        try {
            toReturn.put("records", (Object)this.dbManager.count(this.table));
        }
        catch (SQLException e) {
            log.warn("Unable to count records for index " + this.indexName, (Throwable)e);
        }
        toReturn.put("crossReferencedLayers", this.crossReferenced);
        return toReturn;
    }

    public void insert(Document toInsertRecord) throws SDIInteractionException {
        log.info("Inserting {} in index {}", (Object)toInsertRecord, (Object)this.table.getTablename());
        try {
            PreparedStatement ps = this.dbManager.prepareInsertStatement(this.table, false, true);
            this.table.fillObjectsPreparedStatement((Map<String, Object>)toInsertRecord, ps);
            ps.execute();
        }
        catch (Throwable t) {
            log.error("Unable to insert {} into {} ", new Object[]{toInsertRecord, this.table.getTablename(), t});
            throw new SDIInteractionException("Unable to insert record in postgis index " + this.table.getTablename(), t);
        }
    }

    public void removeByFieldValue(PostgisTable.Field field, String id) throws SDIInteractionException {
        log.info("Deleting {}={} from index {}", new Object[]{field.getName(), id, this.table.getTablename()});
        try {
            this.dbManager.deleteByFieldValue(this.table, field, id);
        }
        catch (Throwable t) {
            log.error("Unable to delete {}={} from index {}", new Object[]{field.getName(), id, this.table.getTablename(), t});
            throw new SDIInteractionException("Unable to delete record in postgis index " + this.table.getTablename(), t);
        }
    }

    public int updateIsVisible(Boolean value, List<String> ids) throws SDIInteractionException {
        log.info("Updating {}={} in index {} for projectIds {}", new Object[]{"displayed_project", value, this.table.getTablename(), ids});
        try {
            PreparedStatement ps = this.dbManager.prepareStatement("Update " + this.table.getTablename() + " SET " + "displayed_project" + " = ? WHERE " + "projectid" + " = ?");
            ps.setBoolean(1, value);
            int count = 0;
            for (String s : ids) {
                log.debug("");
                ps.setString(2, s);
                count += ps.executeUpdate();
            }
            log.info("Updated {} elements out of requested {} ids in table ", new Object[]{count, ids.size(), this.table.getTablename()});
            return count;
        }
        catch (Throwable t) {
            log.error("Unable to update {}={} in index {} for projectIds {}", new Object[]{"displayed_project", value, this.table.getTablename(), ids, t});
            throw new SDIInteractionException("Unable to delete record in postgis index " + this.table.getTablename(), t);
        }
    }

    public static class StandardFields {
        public static final PostgisTable.Field PROJECT_ID = new PostgisTable.Field("projectid", PostgisTable.FieldType.TEXT);
        public static final PostgisTable.Field GEOM = new PostgisTable.Field("geom", PostgisTable.FieldType.GEOMETRY);
        public static final PostgisTable.Field DISPLAY = new PostgisTable.Field("displayed_project", PostgisTable.FieldType.BOOLEAN);
        public static final PostgisTable.Field GEOV_LINK = new PostgisTable.Field("geov_link", PostgisTable.FieldType.TEXT);
    }
}

