/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.cms.sdi.engine;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.gcube.application.cms.sdi.engine.PostgisDBManagerI;
import org.gcube.application.cms.sdi.engine.PostgisTable;
import org.gcube.application.cms.sdi.faults.DataParsingException;
import org.gcube.application.geoportal.common.model.legacy.BBOX;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PostgisDBManager
implements PostgisDBManagerI {
    private static final Logger log = LoggerFactory.getLogger(PostgisDBManager.class);
    private Connection conn = null;

    public PostgisDBManager(Connection conn) throws SQLException {
        this.conn = conn;
    }

    @Override
    public void create(PostgisTable toCreate) throws SQLException {
        String createStmt = toCreate.getCreateStatement();
        log.debug("Executing create : " + createStmt);
        this.conn.createStatement().executeUpdate(createStmt);
    }

    @Override
    public void commit() throws SQLException {
        this.conn.commit();
    }

    @Override
    public PreparedStatement prepareInsertStatement(PostgisTable target, boolean createTable, boolean geometryAsText) throws SQLException {
        if (createTable) {
            this.create(target);
        }
        String insertStmt = target.getInsertionStatement(geometryAsText);
        log.debug("Preparing insert statement : " + insertStmt);
        return this.conn.prepareStatement(insertStmt);
    }

    @Override
    public PreparedStatement prepareStatement(String stmt) throws SQLException {
        return this.conn.prepareStatement(stmt);
    }

    @Override
    public int deleteByFieldValue(PostgisTable target, PostgisTable.Field field, Object value) throws SQLException {
        String query = target.getDeleteByFieldStatement(field);
        log.debug("Preparing DELETE SQL {} with field {} = {} ", new Object[]{query, field, value});
        PreparedStatement stmt = this.conn.prepareStatement(query);
        target.setObjectInPreparedStatement(field, value, stmt, 1);
        int result = stmt.executeUpdate();
        log.debug("DELETED {} rows ", (Object)result);
        return result;
    }

    @Override
    public void deleteTable(String tableName) throws SQLException {
        this.conn.createStatement().executeUpdate("DROP TABLE " + tableName);
    }

    @Override
    public void truncate(String tableName) throws SQLException {
        this.conn.createStatement().executeUpdate("TRUNCATE Table " + tableName);
    }

    @Override
    public ResultSet queryAll(PostgisTable table) throws SQLException {
        return this.conn.createStatement().executeQuery("Select * from " + table.getTablename());
    }

    @Override
    public long count(PostgisTable table) throws SQLException {
        ResultSet rs = this.conn.createStatement().executeQuery("Select count(*) from " + table.getTablename());
        rs.next();
        return rs.getLong(1);
    }

    protected static class DBUtils {
        private static Pattern pattern = Pattern.compile("(?!=\\d\\.\\d\\.)([\\d.]+)");

        protected DBUtils() {
        }

        public static BBOX parseST_Extent(String extent) throws DataParsingException {
            try {
                log.debug("Parsing BBOX " + extent);
                Matcher m = pattern.matcher(extent);
                if (!m.find()) {
                    throw new DataParsingException("Unable to get minLong ");
                }
                Double minLong = Double.parseDouble(m.group(1));
                if (!m.find()) {
                    throw new DataParsingException("Unable to get minLat ");
                }
                Double minLat = Double.parseDouble(m.group(1));
                if (!m.find()) {
                    throw new DataParsingException("Unable to get maxLong ");
                }
                Double maxLong = Double.parseDouble(m.group(1));
                if (!m.find()) {
                    throw new DataParsingException("Unable to get maxLat ");
                }
                Double maxLat = Double.parseDouble(m.group(1));
                return new BBOX(maxLat, maxLong, minLat, minLong);
            }
            catch (Throwable t) {
                throw new DataParsingException("Invalid BBOX " + extent, t);
            }
        }
    }
}

