/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.cms.sdi.model;

import java.util.ArrayList;
import lombok.NonNull;
import org.gcube.application.geoportal.common.model.document.filesets.RegisteredFile;

public abstract class SupportedFormat {
    @NonNull
    private String fileExtension;
    protected Boolean isProposedFilesetValid = false;
    private ArrayList<RegisteredFile> toUseFileSet = new ArrayList();

    public static ArrayList<SupportedFormat> getByExtension(String ... extensions) {
        ArrayList<SupportedFormat> toReturn = new ArrayList<SupportedFormat>();
        block8: for (String extension : extensions) {
            switch (extension = extension.toLowerCase()) {
                case ".tif": {
                    toReturn.add(new SupportedFormat(".tif"){

                        @Override
                        public void consider(RegisteredFile f) {
                            if (f.getName().endsWith(this.getFileExtension())) {
                                this.getToUseFileSet().add(f);
                                this.isProposedFilesetValid = true;
                            }
                        }
                    });
                    continue block8;
                }
                case ".shp": {
                    toReturn.add(new SupportedFormat(".shp"){

                        @Override
                        public void consider(RegisteredFile f) {
                            this.getToUseFileSet().add(f);
                            if (f.getName().endsWith(this.getFileExtension())) {
                                this.isProposedFilesetValid = true;
                            }
                        }
                    });
                }
            }
        }
        return toReturn;
    }

    public abstract void consider(RegisteredFile var1);

    public String toString() {
        return this.fileExtension;
    }

    @NonNull
    public String getFileExtension() {
        return this.fileExtension;
    }

    public Boolean getIsProposedFilesetValid() {
        return this.isProposedFilesetValid;
    }

    public ArrayList<RegisteredFile> getToUseFileSet() {
        return this.toUseFileSet;
    }

    public SupportedFormat(@NonNull String fileExtension) {
        if (fileExtension == null) {
            throw new NullPointerException("fileExtension is marked @NonNull but is null");
        }
        this.fileExtension = fileExtension;
    }
}

