/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.cms.sdi.engine;

import it.geosolutions.geoserver.rest.GeoServerRESTPublisher;
import it.geosolutions.geoserver.rest.GeoServerRESTReader;
import it.geosolutions.geoserver.rest.decoder.RESTFeatureType;
import it.geosolutions.geoserver.rest.decoder.RESTLayer;
import it.geosolutions.geoserver.rest.encoder.GSLayerEncoder;
import it.geosolutions.geoserver.rest.encoder.GSResourceEncoder;
import it.geosolutions.geoserver.rest.encoder.feature.GSFeatureTypeEncoder;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.List;
import org.bson.Document;
import org.gcube.application.cms.plugins.requests.BaseExecutionRequest;
import org.gcube.application.cms.sdi.engine.PostgisTable;
import org.gcube.application.cms.sdi.engine.SDIManager;
import org.gcube.application.cms.sdi.faults.SDIInteractionException;
import org.gcube.application.cms.sdi.model.GCubeSDILayerBuilder;
import org.gcube.application.cms.sdi.model.SupportedFormat;
import org.gcube.application.cms.serialization.Serialization;
import org.gcube.application.geoportal.common.model.document.filesets.RegisteredFile;
import org.gcube.application.geoportal.common.model.document.filesets.RegisteredFileSet;
import org.gcube.application.geoportal.common.model.document.filesets.sdi.GCubeSDILayer;
import org.gcube.application.geoportal.common.model.document.filesets.sdi.GeoServerPlatform;
import org.gcube.application.geoportal.common.model.document.filesets.sdi.PlatformInfo;
import org.gcube.application.geoportal.common.model.rest.DatabaseConnection;
import org.gcube.data.transfer.library.TransferResult;
import org.gcube.data.transfer.library.faults.DestinationNotSetException;
import org.gcube.data.transfer.library.faults.FailedTransferException;
import org.gcube.data.transfer.library.faults.InitializationException;
import org.gcube.data.transfer.library.faults.InvalidDestinationException;
import org.gcube.data.transfer.library.faults.InvalidSourceException;
import org.gcube.data.transfer.library.faults.SourceNotSetException;
import org.gcube.data.transfer.model.Destination;
import org.gcube.data.transfer.model.DestinationClashPolicy;
import org.gcube.spatial.data.gis.is.AbstractGeoServerDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SDIManagerWrapper
extends SDIManager {
    private static final Logger log = LoggerFactory.getLogger(SDIManagerWrapper.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RegisteredFileSet materializeLayer(RegisteredFileSet fileSet, Document params) throws SDIInteractionException {
        try {
            log.debug("Materializing FS {} on {} ", (Object)fileSet, (Object)this.getGeoserverHostName());
            String workspace = BaseExecutionRequest.getMandatory((String)"workspace", (Document)params);
            String documentID = BaseExecutionRequest.getMandatory((String)"documentID", (Document)params);
            String basePersistencePAth = BaseExecutionRequest.getMandatory((String)"basePersistencePath", (Document)params);
            if (fileSet.getPayloads().isEmpty()) {
                throw new SDIInteractionException("No payload to materialize");
            }
            GCubeSDILayerBuilder layerBuilder = new GCubeSDILayerBuilder();
            layerBuilder.setWorkspace(workspace);
            layerBuilder.setHost(this.getGeoserverHostName());
            ArrayList<SupportedFormat> toCheckFormats = SupportedFormat.getByExtension(".tif", ".shp");
            SupportedFormat selectedFormat = null;
            String baseName = null;
            for (SupportedFormat format : toCheckFormats) {
                log.debug("Checking for {}", (Object)format);
                for (Object o : fileSet.getPayloads()) {
                    RegisteredFile file = (RegisteredFile)Serialization.convert(o, RegisteredFile.class);
                    format.consider(file);
                }
                if (!format.getIsProposedFilesetValid().booleanValue()) continue;
                log.debug("Selected format is {}. Fileset is {}", (Object)format, format.getToUseFileSet());
                selectedFormat = format;
                baseName = format.getToUseFileSet().get(0).getName();
                baseName = org.gcube.application.geoportal.common.utils.Files.fixFilename((String)baseName.substring(0, baseName.lastIndexOf(46)));
                break;
            }
            if (selectedFormat == null) {
                throw new SDIInteractionException("Unable to identify layer format. Configured formats are " + toCheckFormats);
            }
            log.debug("Base layer name is {}, checking conflicts.. ", baseName);
            String toSetLayerName = baseName;
            int count = 0;
            GeoServerRESTReader gsReader = this.getCurrentGeoserver().getReader();
            while (gsReader.getLayer(workspace, toSetLayerName) != null) {
                toSetLayerName = baseName + "_" + ++count;
                log.debug("layer for " + baseName + " already existing, trying " + toSetLayerName);
            }
            log.debug("Layer name will be {}", toSetLayerName);
            layerBuilder.setLayerName(toSetLayerName);
            String storeName = toSetLayerName + "_store";
            layerBuilder.setStoreName(storeName);
            GeoServerRESTPublisher publisher = this.getCurrentGeoserver().getPublisher();
            log.debug("Trying to create remote workspace : " + workspace);
            this.createWorkspace(workspace);
            Boolean published = null;
            switch (selectedFormat.getFileExtension()) {
                case ".tif": {
                    RegisteredFile f = selectedFormat.getToUseFileSet().get(0);
                    File temp = null;
                    try {
                        temp = org.gcube.application.geoportal.common.utils.Files.downloadFromUrl((String)f.getName(), (String)f.getLink());
                        published = publisher.publishGeoTIFF(workspace, storeName, toSetLayerName, temp, "EPSG:4326", GSResourceEncoder.ProjectionPolicy.REPROJECT_TO_DECLARED, "raster");
                        break;
                    }
                    finally {
                        if (temp != null) {
                            Files.deleteIfExists(temp.toPath());
                        }
                    }
                }
                case ".shp": {
                    String absolutePath = this.transferFilesetToGS(basePersistencePAth, documentID, selectedFormat.getToUseFileSet(), fileSet.getUUID(), toSetLayerName, baseName, layerBuilder);
                    URL directoryPath = new URL("file:" + absolutePath + "/" + toSetLayerName + ".shp");
                    published = publisher.publishShp(workspace, storeName, null, toSetLayerName, GeoServerRESTPublisher.UploadMethod.EXTERNAL, directoryPath.toURI(), "EPSG:4326", "");
                    break;
                }
                default: {
                    throw new SDIInteractionException("Unsupported data format");
                }
            }
            if (!published.booleanValue()) {
                throw new SDIInteractionException("Unable to publish layer " + toSetLayerName + " under " + workspace + ". Unknown Geoserver fault.");
            }
            RESTLayer l = gsReader.getLayer(workspace, toSetLayerName);
            RESTFeatureType f = gsReader.getFeatureType(l);
            layerBuilder.setBBOX(f.getMaxX(), f.getMinX(), f.getMaxY(), f.getMinY(), 0.0, 0.0);
            GCubeSDILayer materialization = layerBuilder.getLayer();
            log.info("Generated Materialization {}", (Object)materialization);
            ArrayList<GCubeSDILayer> materializations = fileSet.getMaterializations();
            if (materializations == null) {
                materializations = new ArrayList<GCubeSDILayer>();
            }
            materializations.add(materialization);
            fileSet.put("_materializations", materializations);
            return fileSet;
        }
        catch (SDIInteractionException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new SDIInteractionException("Unexpected exception while trying to materialize File Set " + t.getMessage(), t);
        }
    }

    private String transferFilesetToGS(String basePersistencePAth, String documentID, List<RegisteredFile> fileSet, String fileSetUUID, String toSetLayerName, String baseName, GCubeSDILayerBuilder layerBuilder) throws MalformedURLException, InvalidSourceException, SourceNotSetException, InvalidDestinationException, DestinationNotSetException, InitializationException, FailedTransferException {
        String folderRelativePath = basePersistencePAth + "/" + documentID + "/" + fileSetUUID + "/" + toSetLayerName;
        log.debug("GS Relative destination path is {}", (Object)folderRelativePath);
        layerBuilder.setPersistencePath(folderRelativePath);
        ArrayList<String> filenames = new ArrayList<String>();
        String absolutePath = null;
        for (RegisteredFile file : fileSet) {
            log.info("Sending {} to GS {} at {} ", new Object[]{file, this.getGeoserverHostName(), folderRelativePath});
            String completeFilename = org.gcube.application.geoportal.common.utils.Files.fixFilename((String)file.getName());
            completeFilename = completeFilename.replaceAll(baseName, toSetLayerName);
            Destination destination = new Destination(completeFilename);
            destination.setCreateSubfolders(Boolean.valueOf(true));
            destination.setOnExistingFileName(DestinationClashPolicy.REWRITE);
            destination.setOnExistingSubFolder(DestinationClashPolicy.APPEND);
            destination.setPersistenceId("geoserver");
            destination.setSubFolder(folderRelativePath);
            log.debug("Sending {} to {}", (Object)file, (Object)destination);
            TransferResult result = this.getDtGeoServer().httpSource(new URL(file.getLink()), destination);
            log.debug("Transferred " + result);
            filenames.add(completeFilename);
            absolutePath = result.getRemotePath().substring(0, result.getRemotePath().lastIndexOf("/"));
        }
        layerBuilder.setFiles(filenames);
        return absolutePath;
    }

    public void deleteLayer(GCubeSDILayer toDelete) throws SDIInteractionException {
        log.trace("Deleting {}", (Object)toDelete);
        try {
            AbstractGeoServerDescriptor gs = this.getCurrentGeoserver();
            GeoServerRESTPublisher publisher = gs.getPublisher();
            block9: for (Object platformObj : toDelete.getPlatformInfo()) {
                PlatformInfo info = (PlatformInfo)Serialization.convert(platformObj, PlatformInfo.class);
                switch (info.getType()) {
                    case "Geoserver": {
                        GeoServerPlatform gsInfo = (GeoServerPlatform)Serialization.convert((Object)info, GeoServerPlatform.class);
                        log.trace("Deleting {} ", (Object)gsInfo);
                        log.trace("Removing datastore {}:{}", (Object)gsInfo.getWorkspace(), (Object)gsInfo.getStoreName());
                        if (!publisher.removeDatastore(gsInfo.getWorkspace(), gsInfo.getStoreName(), true)) {
                            throw new SDIInteractionException("Unable to remove store " + gsInfo.getWorkspace() + ":" + gsInfo.getStoreName());
                        }
                        log.trace("Checking if empty WS {}", (Object)gsInfo.getWorkspace());
                        if (gs.getReader().getDatastores(gsInfo.getWorkspace()).isEmpty() && !publisher.removeWorkspace(gsInfo.getWorkspace(), true)) {
                            throw new SDIInteractionException("Unable to remove WS " + gsInfo.getWorkspace());
                        }
                        String path = gsInfo.getPersistencePath().replace("/srv/geoserver_data", "geoserver");
                        log.info("Deleting files at {} [{}]", (Object)path, (Object)gsInfo.getPersistencePath());
                        this.getDtGeoServer().getWebClient().delete(path);
                        continue block9;
                    }
                }
                throw new SDIInteractionException("Unable to manage platform " + info);
            }
        }
        catch (SDIInteractionException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new SDIInteractionException("Unexpected exception while trying to materialize File Set " + t.getMessage(), t);
        }
    }

    public GCubeSDILayer configureCentroidLayer(String name, String workspace, String storeName, PostgisTable table, DatabaseConnection connection) throws SDIInteractionException {
        GCubeSDILayerBuilder builder = new GCubeSDILayerBuilder().setWorkspace(workspace).setStoreName(storeName).setHost(this.getGeoserverHostName()).setLayerName(name);
        CQL_GS_Feature fte = new CQL_GS_Feature();
        fte.setAbstract("Centroid layer for " + name);
        fte.setEnabled(true);
        fte.setNativeCRS("GEOGCS[\"WGS 84\", DATUM[\"World Geodetic System 1984\", SPHEROID[\"WGS 84\", 6378137.0, 298.257223563, AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\",\"6326\"]], PRIMEM[\"Greenwich\", 0.0, AUTHORITY[\"EPSG\",\"8901\"]],  UNIT[\"degree\", 0.017453292519943295],AXIS[\"Geodetic longitude\", EAST],  AXIS[\"Geodetic latitude\", NORTH],  AUTHORITY[\"EPSG\",\"4326\"]]");
        fte.setTitle(name);
        fte.setName(name);
        fte.setCQL("displayed_project = true");
        fte.setLatLonBoundingBox(-180.0, -90.0, 180.0, 90.0, "GEOGCS[\"WGS 84\", DATUM[\"World Geodetic System 1984\", SPHEROID[\"WGS 84\", 6378137.0, 298.257223563, AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\",\"6326\"]], PRIMEM[\"Greenwich\", 0.0, AUTHORITY[\"EPSG\",\"8901\"]],  UNIT[\"degree\", 0.017453292519943295],AXIS[\"Geodetic longitude\", EAST],  AXIS[\"Geodetic latitude\", NORTH],  AUTHORITY[\"EPSG\",\"4326\"]]");
        String style = "clustered_centroids";
        GSLayerEncoder layerEncoder = new GSLayerEncoder();
        layerEncoder.setDefaultStyle(style);
        layerEncoder.setEnabled(true);
        layerEncoder.setQueryable(Boolean.valueOf(true));
        try {
            this.createWorkspace(workspace);
            this.createStoreFromPostgisDB(workspace, storeName, connection);
            this.publishStyle(org.gcube.application.geoportal.common.utils.Files.getFileFromResources((String)"styles/clustered_points.sld"), style);
            log.info("Creating layer in {} : {} with FTE {} , LE {}", new Object[]{workspace, storeName, fte, layerEncoder});
            if (this.getCurrentGeoserver().getReader().getLayer(workspace, name) == null && !this.getCurrentGeoserver().getPublisher().publishDBLayer(workspace, storeName, (GSFeatureTypeEncoder)fte, layerEncoder)) {
                throw new SDIInteractionException("Unable to create layer " + name);
            }
            log.debug("layer " + name + " already exists");
            return builder.getLayer();
        }
        catch (IllegalArgumentException | MalformedURLException e) {
            throw new SDIInteractionException("Unable to create layer " + name, e);
        }
    }

    private static class CQL_GS_Feature
    extends GSFeatureTypeEncoder {
        private static final String CQL = "CQL";

        private CQL_GS_Feature() {
        }

        public void setCQL(String cql) {
            this.set(CQL, cql);
        }
    }
}

