package org.gcube.application.cms.notifications.config;

import java.util.List;

import org.gcube.application.cms.plugins.events.EventManager.Event;
import org.gcube.com.fasterxml.jackson.annotation.JsonIgnoreProperties;

import lombok.Data;

/**
 *
 * @author Francesco Mangiacrapa at ISTI-CNR francesco.mangiacrapa@isti.cnr.it
 * 
 * Jan 30, 2024
 */

/**
 * Instantiates a new subscribe notification config.
 * 
{
  "subscribeNotifications": [
    {
      "event": "EVENT_NAME",
      "notificationFor": [
        {
          "roles": [
            "USER_ROLE"
          ],
          "when": [
            {
              "target_phase": [
                "TARGET_PHASE"
              ],
              "notify": [
                {
                  "type": "NOTIFICATION_TYPE",
                  "send": "true/false",
                  "attach_pdf_document": "true/false",
                  "message": "PLACEHOLDER_MESSAGE_1"
                }
              ]
            },
            {
              "target_phase": [
                "TARGET_PHASE"
              ],
              "notify": [
                {
                  "type": "NOTIFICATION_TYPE",
                  "send": "true/false",
                  "attach_pdf_document": "true/false",
                  "message": "PLACEHOLDER_MESSAGE_2"
                }
              ]
            }
          ]
        }
      ]
    }
  ],
  "link_to_messages": "link to file containing the messages as properties like ID_MESSAGE_{N} = value"
}
 * 
 */

@Data
@JsonIgnoreProperties(ignoreUnknown = true)
public class SubscribeNotificationEvent {

	Event event;
	List<NotificationFor> notificationFor;
}
