/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.geoportal.common.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Collection;
import org.bson.Document;
import org.gcube.application.geoportal.common.model.document.access.Access;
import org.gcube.application.geoportal.common.model.legacy.InputStreamDescriptor;
import org.gcube.application.geoportal.common.model.rest.RegisterFileSetRequest;
import org.gcube.application.geoportal.common.model.rest.TempFile;
import org.gcube.application.geoportal.common.utils.StorageUtils;
import org.gcube.contentmanagement.blobstorage.transport.backend.RemoteBackendException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileSets {
    private static final Logger log = LoggerFactory.getLogger(FileSets.class);

    public static RequestBuilder build(String parent, String fieldName, String fieldDefinition) {
        return new RequestBuilder().setParentPath(parent).setFieldDefinitionPath(fieldDefinition).setFieldName(fieldName);
    }

    public static RequestBuilder build(String parent, String fieldName, String fieldDefinition, TempFile ... files) {
        return FileSets.build(parent, fieldName, fieldDefinition).add(files);
    }

    public static TempFile asTemp(StorageUtils storage, InputStreamDescriptor descriptor) throws RemoteBackendException, FileNotFoundException {
        return storage.putOntoStorage(descriptor.getStream(), descriptor.getFilename());
    }

    public static TempFile[] asTemp(StorageUtils storage, InputStreamDescriptor ... descriptors) throws RemoteBackendException, FileNotFoundException {
        ArrayList<TempFile> toReturn = new ArrayList<TempFile>();
        for (InputStreamDescriptor desc : descriptors) {
            toReturn.add(storage.putOntoStorage(desc.getStream(), desc.getFilename()));
        }
        return toReturn.toArray(new TempFile[toReturn.size()]);
    }

    public static RegisterFileSetRequest prepareRequestFromFolder(StorageUtils storage, String parentPath, String fieldName, String fieldDefinition, File directory) throws FileNotFoundException {
        File[] children = directory.listFiles();
        InputStreamDescriptor[] iss = new InputStreamDescriptor[children.length];
        return FileSets.prepareRequest(storage, parentPath, fieldName, fieldDefinition, children);
    }

    public static RegisterFileSetRequest prepareRequest(StorageUtils storage, String parentPath, String fieldName, String fieldDefinition, File ... toUpload) throws FileNotFoundException {
        RequestBuilder builder = FileSets.build(parentPath, fieldName, fieldDefinition);
        for (File f : toUpload) {
            if (f.isDirectory()) continue;
            long fileSize = f.length();
            TempFile file = FileSets.asTemp(storage, new InputStreamDescriptor(new FileInputStream(f), f.getName()));
            log.debug("PrepareRequest for tempfile name " + file.getFilename() + " size: " + fileSize);
            file.setSize(fileSize);
            builder.add(file);
        }
        return builder.getTheRequest();
    }

    public static class RequestBuilder {
        RegisterFileSetRequest theRequest = new RegisterFileSetRequest();

        public RequestBuilder addAll(Collection<? extends TempFile> toAdd) {
            if (this.theRequest.getStreams() == null) {
                this.theRequest.setStreams(new ArrayList<TempFile>());
            }
            this.theRequest.getStreams().addAll(toAdd);
            return this;
        }

        public RequestBuilder add(TempFile ... f) {
            if (this.theRequest.getStreams() == null) {
                this.theRequest.setStreams(new ArrayList<TempFile>());
            }
            for (TempFile temp : f) {
                this.theRequest.getStreams().add(temp);
            }
            return this;
        }

        public RequestBuilder add(TempFile f) {
            if (this.theRequest.getStreams() == null) {
                this.theRequest.setStreams(new ArrayList<TempFile>());
            }
            this.theRequest.getStreams().add(f);
            return this;
        }

        public RequestBuilder setFieldDefinitionPath(String path) {
            this.theRequest.setFieldDefinitionPath(path);
            return this;
        }

        public RequestBuilder setParentPath(String path) {
            this.theRequest.setParentPath(path);
            return this;
        }

        public RequestBuilder setFieldName(String fieldName) {
            this.theRequest.setFieldName(fieldName);
            return this;
        }

        public RequestBuilder setClashPolicy(RegisterFileSetRequest.ClashOptions path) {
            this.theRequest.setClashOption(path);
            return this;
        }

        public RequestBuilder setAttributes(Document attributes) {
            this.theRequest.setAttributes(attributes);
            return this;
        }

        public RegisterFileSetRequest getTheRequest() {
            if (this.theRequest.getClashOption() == null) {
                this.setClashPolicy(RegisterFileSetRequest.ClashOptions.REPLACE_EXISTING);
            }
            return this.theRequest;
        }

        public RequestBuilder setAccess(Access access) {
            this.theRequest.setToSetAccess(access);
            return this;
        }
    }
}

