/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.geoportal.common.model.document;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.vdurmont.semver4j.Semver;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.bson.Document;
import org.gcube.application.geoportal.common.model.document.Lock;
import org.gcube.application.geoportal.common.model.document.accounting.PublicationInfo;
import org.gcube.application.geoportal.common.model.document.identification.IdentificationReference;
import org.gcube.application.geoportal.common.model.document.lifecycle.LifecycleInformation;
import org.gcube.application.geoportal.common.model.document.relationships.Relationship;

public class Project {
    public static final String ID = "_id";
    public static final String VERSION = "_version";
    public static final String INFO = "_info";
    public static final String PROFILE_ID = "_profileID";
    public static final String PROFILE_VERSION = "_profileVersion";
    public static final String LIFECYCLE_INFORMATION = "_lifecycleInformation";
    public static final String RELATIONSHIPS = "_relationships";
    public static final String IDENTIFICATION_REFERENCES = "_identificationReferences";
    public static final String THE_DOCUMENT = "_theDocument";
    public static final String LOCK = "_lock";
    @JsonProperty(value="_id")
    private String id;
    @JsonProperty(value="_version")
    private Semver version;
    @JsonProperty(value="_info")
    private PublicationInfo info;
    @JsonProperty(value="_profileID")
    private String profileID;
    @JsonProperty(value="_profileVersion")
    private Semver profileVersion;
    @JsonProperty(value="_lifecycleInformation")
    private LifecycleInformation lifecycleInformation;
    @JsonProperty(value="_relationships")
    private List<Relationship> relationships;
    @JsonProperty(value="_identificationReferences")
    private List<IdentificationReference> identificationReferences;
    @JsonProperty(value="_theDocument")
    private Document theDocument;
    @JsonProperty(value="_lock")
    private Lock lock;

    public boolean isEquivalent(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Project)) {
            return false;
        }
        Project project = (Project)o;
        return Objects.equals(this.getId(), project.getId()) && Objects.equals(this.getVersion(), project.getVersion()) && Objects.equals(this.getInfo(), project.getInfo()) && Objects.equals(this.getProfileID(), project.getProfileID()) && Objects.equals(this.getProfileVersion(), project.getProfileVersion()) && Objects.equals(this.getLifecycleInformation(), project.getLifecycleInformation()) && Objects.equals(this.getIdentificationReferences(), project.getIdentificationReferences()) && Objects.equals(this.getRelationships(), project.getRelationships()) && Objects.equals(this.getTheDocument(), project.getTheDocument());
    }

    @JsonIgnore
    public List<IdentificationReference> getIdentificationReferenceByType(String type) {
        if (this.identificationReferences == null) {
            return Collections.emptyList();
        }
        return this.identificationReferences.stream().filter(item -> item.getType().equals(type)).collect(Collectors.toList());
    }

    @JsonIgnore
    public List<Relationship> getRelationshipsByName(String relation) {
        if (this.relationships == null) {
            return Collections.emptyList();
        }
        return this.relationships.stream().filter(relationship -> relationship.getRelationshipName().equals(relation)).collect(Collectors.toList());
    }

    @JsonIgnore
    public Project addRelation(Relationship rel) {
        if (this.relationships == null) {
            this.relationships = new ArrayList<Relationship>();
        }
        this.relationships.add(rel);
        return this;
    }

    public Project() {
    }

    public Project(String id, Semver version, PublicationInfo info, String profileID, Semver profileVersion, LifecycleInformation lifecycleInformation, List<Relationship> relationships, List<IdentificationReference> identificationReferences, Document theDocument, Lock lock) {
        this.id = id;
        this.version = version;
        this.info = info;
        this.profileID = profileID;
        this.profileVersion = profileVersion;
        this.lifecycleInformation = lifecycleInformation;
        this.relationships = relationships;
        this.identificationReferences = identificationReferences;
        this.theDocument = theDocument;
        this.lock = lock;
    }

    public String getId() {
        return this.id;
    }

    public Semver getVersion() {
        return this.version;
    }

    public PublicationInfo getInfo() {
        return this.info;
    }

    public String getProfileID() {
        return this.profileID;
    }

    public Semver getProfileVersion() {
        return this.profileVersion;
    }

    public LifecycleInformation getLifecycleInformation() {
        return this.lifecycleInformation;
    }

    public List<Relationship> getRelationships() {
        return this.relationships;
    }

    public List<IdentificationReference> getIdentificationReferences() {
        return this.identificationReferences;
    }

    public Document getTheDocument() {
        return this.theDocument;
    }

    public Lock getLock() {
        return this.lock;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setVersion(Semver version) {
        this.version = version;
    }

    public void setInfo(PublicationInfo info) {
        this.info = info;
    }

    public void setProfileID(String profileID) {
        this.profileID = profileID;
    }

    public void setProfileVersion(Semver profileVersion) {
        this.profileVersion = profileVersion;
    }

    public void setLifecycleInformation(LifecycleInformation lifecycleInformation) {
        this.lifecycleInformation = lifecycleInformation;
    }

    public void setRelationships(List<Relationship> relationships) {
        this.relationships = relationships;
    }

    public void setIdentificationReferences(List<IdentificationReference> identificationReferences) {
        this.identificationReferences = identificationReferences;
    }

    public void setTheDocument(Document theDocument) {
        this.theDocument = theDocument;
    }

    public void setLock(Lock lock) {
        this.lock = lock;
    }

    public String toString() {
        return "Project(id=" + this.getId() + ", version=" + this.getVersion() + ", info=" + this.getInfo() + ", profileID=" + this.getProfileID() + ", profileVersion=" + this.getProfileVersion() + ", lifecycleInformation=" + this.getLifecycleInformation() + ", relationships=" + this.getRelationships() + ", identificationReferences=" + this.getIdentificationReferences() + ", theDocument=" + this.getTheDocument() + ", lock=" + this.getLock() + ")";
    }
}

