/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.geoportal.common.model;

import com.jayway.jsonpath.Configuration;
import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Option;
import com.jayway.jsonpath.TypeRef;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.gcube.application.geoportal.common.JSONSerializationProvider;
import org.reflections.Reflections;
import org.reflections.util.ConfigurationBuilder;
import org.reflections.util.FilterBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JSONPathWrapper {
    private static final Logger log = LoggerFactory.getLogger(JSONPathWrapper.class);
    public static Configuration JSON_PATH_ALWAYS_LIST_CONFIG = null;
    public static Configuration JSON_PATH_PATHS_CONFIGURATION = null;
    DocumentContext valueCTX = null;
    DocumentContext pathsCTX = null;
    private static Pattern DOTTED_PATH_PATTERN;
    private static Pattern BRACKET_PATH_PATTERN;

    public JSONPathWrapper(String json) {
        this.valueCTX = JsonPath.using((Configuration)JSON_PATH_ALWAYS_LIST_CONFIG).parse(json);
        this.pathsCTX = JsonPath.using((Configuration)JSON_PATH_PATHS_CONFIGURATION).parse(json);
    }

    public List<Object> getByPath(String path) {
        return this.getByPath(path, Object.class);
    }

    public List<String> getMatchingPaths(String path) {
        List l = (List)this.pathsCTX.read(path, new com.jayway.jsonpath.Predicate[0]);
        l.removeIf(p -> p == null);
        return l;
    }

    public <T> List<T> getByPath(String path, Class<T> clazz) {
        List l = (List)this.valueCTX.read(path, new TypeRef<List<T>>(){});
        l.removeIf(p -> p == null);
        return l;
    }

    public JSONPathWrapper setElement(String path, Object toSet) {
        log.debug("Setting Path {} = {}", (Object)path, toSet);
        JsonPath jPath = JsonPath.compile((String)path, (com.jayway.jsonpath.Predicate[])new com.jayway.jsonpath.Predicate[0]);
        if (jPath.isDefinite()) {
            this.valueCTX.set(path, toSet, new com.jayway.jsonpath.Predicate[0]);
        } else {
            log.debug("Path is not definte, evaluating matching paths..");
            for (String p : this.getMatchingPaths(path)) {
                log.debug("Actually setting {} as {} ", (Object)p, toSet);
                this.setElement(p, toSet);
            }
        }
        return this;
    }

    public JSONPathWrapper putElement(String path, String elementName, Object toSet) {
        log.debug("Putting {} = {} at Path {}", new Object[]{elementName, toSet, path});
        JsonPath jPath = JsonPath.compile((String)path, (com.jayway.jsonpath.Predicate[])new com.jayway.jsonpath.Predicate[0]);
        if (jPath.isDefinite()) {
            this.valueCTX.put(path, elementName, toSet, new com.jayway.jsonpath.Predicate[0]);
        } else {
            log.debug("Path is not definte, evaluating matching paths..");
            for (String p : this.getMatchingPaths(path)) {
                this.putElement(p, elementName, toSet);
            }
        }
        return this;
    }

    public JSONPathWrapper addElementToArray(String path, Object toAdd) {
        log.debug("Setting Path {} = {}", (Object)path, toAdd);
        JsonPath jPath = JsonPath.compile((String)path, (com.jayway.jsonpath.Predicate[])new com.jayway.jsonpath.Predicate[0]);
        if (jPath.isDefinite()) {
            this.valueCTX.add(path, toAdd, new com.jayway.jsonpath.Predicate[0]);
        } else {
            log.debug("Path is not definte, evaluating matching paths..");
            for (String p : this.getMatchingPaths(path)) {
                this.addElementToArray(p, toAdd);
            }
        }
        return this;
    }

    static List<String> tokenizePath(String path) {
        List<String> toReturn = null;
        log.debug("Tokenizing JSON Path {} ", (Object)path);
        if (path.matches("(\\$\\.)?\\w.*")) {
            toReturn = JSONPathWrapper.getByRegex(path, DOTTED_PATH_PATTERN);
        } else if (path.matches("(\\$)?\\[\\'.*")) {
            toReturn = JSONPathWrapper.getByRegex(path, BRACKET_PATH_PATTERN);
        }
        log.debug("Path {} as tokens {}", (Object)path, toReturn);
        return toReturn;
    }

    private static List<String> getByRegex(String s, Pattern p) {
        ArrayList<String> toReturn = new ArrayList<String>();
        Matcher m = p.matcher(s);
        log.trace("Groups from {} with {} : ", (Object)s, (Object)p.pattern());
        while (m.find()) {
            String found = m.group();
            toReturn.add(found);
        }
        return toReturn;
    }

    static String extractFieldNameFromPathElement(String p) {
        Matcher m = Pattern.compile("\\$?\\.?(\\[')?([a-zA-Z_]+)").matcher(p);
        m.find();
        return m.group(2);
    }

    public DocumentContext getValueCTX() {
        return this.valueCTX;
    }

    static {
        Reflections reflections = new Reflections((org.reflections.Configuration)new ConfigurationBuilder().forPackage("org.gcube.application", new ClassLoader[0]).filterInputsBy((Predicate)new FilterBuilder().includePackage("org.gcube.application")));
        reflections.getSubTypesOf(JSONSerializationProvider.class).iterator().forEachRemaining(providerClass -> {
            if (!providerClass.isInterface()) {
                try {
                    log.warn("Loading JSON Provider {} ", providerClass);
                    JSONSerializationProvider provider = (JSONSerializationProvider)providerClass.newInstance();
                    provider.setJSONWrapperDefaults();
                }
                catch (Throwable t) {
                    log.error("Unable to instantiate provider " + providerClass, t);
                }
            }
        });
        JSON_PATH_ALWAYS_LIST_CONFIG = Configuration.builder().options(new Option[]{Option.ALWAYS_RETURN_LIST, Option.SUPPRESS_EXCEPTIONS, Option.DEFAULT_PATH_LEAF_TO_NULL}).build();
        JSON_PATH_PATHS_CONFIGURATION = Configuration.builder().options(new Option[]{Option.AS_PATH_LIST, Option.SUPPRESS_EXCEPTIONS, Option.DEFAULT_PATH_LEAF_TO_NULL}).build();
        DOTTED_PATH_PATTERN = Pattern.compile("(\\$?\\.\\w*(\\[((\\?\\(.*\\))|(\\d+|\\*))\\])?)(?=(\\.|$)?)");
        BRACKET_PATH_PATTERN = Pattern.compile("(\\$?\\['\\w*'\\](\\[((\\?\\(.*\\))|(\\d+|\\*))\\])?)");
    }
}

