/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.geoportal.common.model.document.lifecycle;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.List;
import org.gcube.application.geoportal.common.model.document.lifecycle.TriggeredEvents;

public class LifecycleInformation {
    public static final String PHASE = "_phase";
    public static final String LAST_INVOKED_STEP = "_lastInvokedStep";
    public static final String LAST_OPERATION_STATUS = "_lastOperationStatus";
    public static final String ERROR_MESSAGES = "_errorMessages";
    public static final String WARNING_MESSAGES = "_warningMessages";
    public static final String TRIGGERED_EVENTS = "_triggeredEvents";
    public static final String NOTES = "_notes";
    @JsonProperty(value="_phase")
    private String phase;
    @JsonProperty(value="_lastInvokedStep")
    private String lastInvokedStep;
    @JsonProperty(value="_lastOperationStatus")
    private Status lastOperationStatus;
    @JsonProperty(value="_errorMessages")
    private List<String> errorMessages;
    @JsonProperty(value="_warningMessages")
    private List<String> warningMessages;
    @JsonProperty(value="_triggeredEvents")
    private List<TriggeredEvents> triggeredEvents;
    @JsonProperty(value="_notes")
    private String notes;

    @JsonIgnore
    public TriggeredEvents getLastEvent() {
        if (this.triggeredEvents == null || this.triggeredEvents.isEmpty()) {
            return null;
        }
        return this.triggeredEvents.get(this.triggeredEvents.size() - 1);
    }

    @JsonIgnore
    public LifecycleInformation addErrorMessage(String msg) {
        if (this.errorMessages == null) {
            this.errorMessages = new ArrayList<String>();
        }
        this.errorMessages.add(msg);
        return this;
    }

    @JsonIgnore
    public LifecycleInformation addWarningMessage(String msg) {
        if (this.warningMessages == null) {
            this.warningMessages = new ArrayList<String>();
        }
        this.warningMessages.add(msg);
        return this;
    }

    @JsonIgnore
    public LifecycleInformation addEventReport(TriggeredEvents info) {
        if (this.triggeredEvents == null) {
            this.triggeredEvents = new ArrayList<TriggeredEvents>();
        }
        this.triggeredEvents.add(info);
        return this;
    }

    @JsonIgnore
    public LifecycleInformation cleanState() {
        this.setLastOperationStatus(null);
        this.setLastInvokedStep(null);
        this.setTriggeredEvents(new ArrayList<TriggeredEvents>());
        this.setErrorMessages(new ArrayList<String>());
        this.setWarningMessages(new ArrayList<String>());
        return this;
    }

    public String getPhase() {
        return this.phase;
    }

    public String getLastInvokedStep() {
        return this.lastInvokedStep;
    }

    public Status getLastOperationStatus() {
        return this.lastOperationStatus;
    }

    public List<String> getErrorMessages() {
        return this.errorMessages;
    }

    public List<String> getWarningMessages() {
        return this.warningMessages;
    }

    public List<TriggeredEvents> getTriggeredEvents() {
        return this.triggeredEvents;
    }

    public String getNotes() {
        return this.notes;
    }

    public void setPhase(String phase) {
        this.phase = phase;
    }

    public void setLastInvokedStep(String lastInvokedStep) {
        this.lastInvokedStep = lastInvokedStep;
    }

    public void setLastOperationStatus(Status lastOperationStatus) {
        this.lastOperationStatus = lastOperationStatus;
    }

    public void setErrorMessages(List<String> errorMessages) {
        this.errorMessages = errorMessages;
    }

    public void setWarningMessages(List<String> warningMessages) {
        this.warningMessages = warningMessages;
    }

    public void setTriggeredEvents(List<TriggeredEvents> triggeredEvents) {
        this.triggeredEvents = triggeredEvents;
    }

    public void setNotes(String notes) {
        this.notes = notes;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LifecycleInformation)) {
            return false;
        }
        LifecycleInformation other = (LifecycleInformation)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$phase = this.getPhase();
        String other$phase = other.getPhase();
        if (this$phase == null ? other$phase != null : !this$phase.equals(other$phase)) {
            return false;
        }
        String this$lastInvokedStep = this.getLastInvokedStep();
        String other$lastInvokedStep = other.getLastInvokedStep();
        if (this$lastInvokedStep == null ? other$lastInvokedStep != null : !this$lastInvokedStep.equals(other$lastInvokedStep)) {
            return false;
        }
        Status this$lastOperationStatus = this.getLastOperationStatus();
        Status other$lastOperationStatus = other.getLastOperationStatus();
        if (this$lastOperationStatus == null ? other$lastOperationStatus != null : !((Object)((Object)this$lastOperationStatus)).equals((Object)other$lastOperationStatus)) {
            return false;
        }
        List<String> this$errorMessages = this.getErrorMessages();
        List<String> other$errorMessages = other.getErrorMessages();
        if (this$errorMessages == null ? other$errorMessages != null : !((Object)this$errorMessages).equals(other$errorMessages)) {
            return false;
        }
        List<String> this$warningMessages = this.getWarningMessages();
        List<String> other$warningMessages = other.getWarningMessages();
        if (this$warningMessages == null ? other$warningMessages != null : !((Object)this$warningMessages).equals(other$warningMessages)) {
            return false;
        }
        List<TriggeredEvents> this$triggeredEvents = this.getTriggeredEvents();
        List<TriggeredEvents> other$triggeredEvents = other.getTriggeredEvents();
        if (this$triggeredEvents == null ? other$triggeredEvents != null : !((Object)this$triggeredEvents).equals(other$triggeredEvents)) {
            return false;
        }
        String this$notes = this.getNotes();
        String other$notes = other.getNotes();
        return !(this$notes == null ? other$notes != null : !this$notes.equals(other$notes));
    }

    protected boolean canEqual(Object other) {
        return other instanceof LifecycleInformation;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $phase = this.getPhase();
        result = result * 59 + ($phase == null ? 43 : $phase.hashCode());
        String $lastInvokedStep = this.getLastInvokedStep();
        result = result * 59 + ($lastInvokedStep == null ? 43 : $lastInvokedStep.hashCode());
        Status $lastOperationStatus = this.getLastOperationStatus();
        result = result * 59 + ($lastOperationStatus == null ? 43 : ((Object)((Object)$lastOperationStatus)).hashCode());
        List<String> $errorMessages = this.getErrorMessages();
        result = result * 59 + ($errorMessages == null ? 43 : ((Object)$errorMessages).hashCode());
        List<String> $warningMessages = this.getWarningMessages();
        result = result * 59 + ($warningMessages == null ? 43 : ((Object)$warningMessages).hashCode());
        List<TriggeredEvents> $triggeredEvents = this.getTriggeredEvents();
        result = result * 59 + ($triggeredEvents == null ? 43 : ((Object)$triggeredEvents).hashCode());
        String $notes = this.getNotes();
        result = result * 59 + ($notes == null ? 43 : $notes.hashCode());
        return result;
    }

    public String toString() {
        return "LifecycleInformation(phase=" + this.getPhase() + ", lastInvokedStep=" + this.getLastInvokedStep() + ", lastOperationStatus=" + (Object)((Object)this.getLastOperationStatus()) + ", errorMessages=" + this.getErrorMessages() + ", warningMessages=" + this.getWarningMessages() + ", triggeredEvents=" + this.getTriggeredEvents() + ", notes=" + this.getNotes() + ")";
    }

    public static enum Status {
        OK,
        ERROR,
        WARNING;

    }

    public static final class CommonPhases {
        public static final String DRAFT_PHASE = "DRAFT";
    }
}

