package org.gcube.application.geoportal.common.model.document.relationships;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.*;
import org.gcube.application.geoportal.common.model.document.Project;

import java.util.List;

@NoArgsConstructor
@AllArgsConstructor
@Getter
@Setter
@ToString
public class RelationshipNavigationObject {
    public static final String CHILDREN="_children";
    public static final String TARGET="_target";

    @JsonProperty(CHILDREN)
    List<RelationshipNavigationObject> children;

    @NonNull
    @JsonProperty(TARGET)
    Project target;
}
