/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.geoportal.common.utils;

import org.gcube.common.authorization.client.Constants;
import org.gcube.common.authorization.library.AuthorizationEntry;
import org.gcube.common.authorization.library.provider.SecurityTokenProvider;
import org.gcube.common.scope.api.ScopeProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContextUtils {
    private static final Logger log = LoggerFactory.getLogger(ContextUtils.class);

    public static String getCurrentScope() {
        try {
            String token = SecurityTokenProvider.instance.get();
            log.trace("Token is : " + token.substring(0, 2) + "..." + token.substring(token.length() - 3));
            if (token == null) {
                throw new Exception("Security Token is null");
            }
            AuthorizationEntry entry = Constants.authorizationService().get(token);
            return entry.getContext();
        }
        catch (Exception e) {
            log.trace("Unable to resolve token, checking scope provider..", (Throwable)e);
            return ScopeProvider.instance.get();
        }
    }

    public static String getCurrentCaller() {
        try {
            String token = SecurityTokenProvider.instance.get();
            log.trace("Token is : " + token.substring(0, 2) + "..." + token.substring(token.length() - 3));
            if (token == null) {
                throw new Exception("Security Token is null");
            }
            AuthorizationEntry entry = Constants.authorizationService().get(token);
            return entry.getClientInfo().getId();
        }
        catch (Exception e) {
            log.trace("Unable to resolve token, checking scope provider..", (Throwable)e);
            return "Unidentified data-transfer user";
        }
    }
}

