/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.geoportal.common.model.rest;

import java.util.List;
import javax.xml.bind.annotation.XmlRootElement;
import org.bson.Document;
import org.gcube.application.geoportal.common.faults.InvalidRequestException;
import org.gcube.application.geoportal.common.model.document.access.Access;
import org.gcube.application.geoportal.common.model.rest.TempFile;

@XmlRootElement
public class RegisterFileSetRequest {
    private String fieldDefinitionPath;
    private String parentPath;
    private String fieldName;
    private List<TempFile> streams;
    private Document attributes;
    private Access toSetAccess;
    private ClashOptions clashOption;

    public void validate() throws InvalidRequestException {
        if (this.streams == null || this.streams.isEmpty()) {
            throw new InvalidRequestException("No Temp File declared");
        }
        for (TempFile t : this.streams) {
            t.validate();
        }
    }

    public String getFieldDefinitionPath() {
        return this.fieldDefinitionPath;
    }

    public String getParentPath() {
        return this.parentPath;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public List<TempFile> getStreams() {
        return this.streams;
    }

    public Document getAttributes() {
        return this.attributes;
    }

    public Access getToSetAccess() {
        return this.toSetAccess;
    }

    public ClashOptions getClashOption() {
        return this.clashOption;
    }

    public void setFieldDefinitionPath(String fieldDefinitionPath) {
        this.fieldDefinitionPath = fieldDefinitionPath;
    }

    public void setParentPath(String parentPath) {
        this.parentPath = parentPath;
    }

    public void setFieldName(String fieldName) {
        this.fieldName = fieldName;
    }

    public void setStreams(List<TempFile> streams) {
        this.streams = streams;
    }

    public void setAttributes(Document attributes) {
        this.attributes = attributes;
    }

    public void setToSetAccess(Access toSetAccess) {
        this.toSetAccess = toSetAccess;
    }

    public void setClashOption(ClashOptions clashOption) {
        this.clashOption = clashOption;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RegisterFileSetRequest)) {
            return false;
        }
        RegisterFileSetRequest other = (RegisterFileSetRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$fieldDefinitionPath = this.getFieldDefinitionPath();
        String other$fieldDefinitionPath = other.getFieldDefinitionPath();
        if (this$fieldDefinitionPath == null ? other$fieldDefinitionPath != null : !this$fieldDefinitionPath.equals(other$fieldDefinitionPath)) {
            return false;
        }
        String this$parentPath = this.getParentPath();
        String other$parentPath = other.getParentPath();
        if (this$parentPath == null ? other$parentPath != null : !this$parentPath.equals(other$parentPath)) {
            return false;
        }
        String this$fieldName = this.getFieldName();
        String other$fieldName = other.getFieldName();
        if (this$fieldName == null ? other$fieldName != null : !this$fieldName.equals(other$fieldName)) {
            return false;
        }
        List<TempFile> this$streams = this.getStreams();
        List<TempFile> other$streams = other.getStreams();
        if (this$streams == null ? other$streams != null : !((Object)this$streams).equals(other$streams)) {
            return false;
        }
        Document this$attributes = this.getAttributes();
        Document other$attributes = other.getAttributes();
        if (this$attributes == null ? other$attributes != null : !this$attributes.equals(other$attributes)) {
            return false;
        }
        Access this$toSetAccess = this.getToSetAccess();
        Access other$toSetAccess = other.getToSetAccess();
        if (this$toSetAccess == null ? other$toSetAccess != null : !this$toSetAccess.equals(other$toSetAccess)) {
            return false;
        }
        ClashOptions this$clashOption = this.getClashOption();
        ClashOptions other$clashOption = other.getClashOption();
        return !(this$clashOption == null ? other$clashOption != null : !((Object)((Object)this$clashOption)).equals((Object)other$clashOption));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RegisterFileSetRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $fieldDefinitionPath = this.getFieldDefinitionPath();
        result = result * 59 + ($fieldDefinitionPath == null ? 43 : $fieldDefinitionPath.hashCode());
        String $parentPath = this.getParentPath();
        result = result * 59 + ($parentPath == null ? 43 : $parentPath.hashCode());
        String $fieldName = this.getFieldName();
        result = result * 59 + ($fieldName == null ? 43 : $fieldName.hashCode());
        List<TempFile> $streams = this.getStreams();
        result = result * 59 + ($streams == null ? 43 : ((Object)$streams).hashCode());
        Document $attributes = this.getAttributes();
        result = result * 59 + ($attributes == null ? 43 : $attributes.hashCode());
        Access $toSetAccess = this.getToSetAccess();
        result = result * 59 + ($toSetAccess == null ? 43 : $toSetAccess.hashCode());
        ClashOptions $clashOption = this.getClashOption();
        result = result * 59 + ($clashOption == null ? 43 : ((Object)((Object)$clashOption)).hashCode());
        return result;
    }

    public String toString() {
        return "RegisterFileSetRequest(fieldDefinitionPath=" + this.getFieldDefinitionPath() + ", parentPath=" + this.getParentPath() + ", fieldName=" + this.getFieldName() + ", streams=" + this.getStreams() + ", attributes=" + this.getAttributes() + ", toSetAccess=" + this.getToSetAccess() + ", clashOption=" + (Object)((Object)this.getClashOption()) + ")";
    }

    public RegisterFileSetRequest(String fieldDefinitionPath, String parentPath, String fieldName, List<TempFile> streams, Document attributes, Access toSetAccess, ClashOptions clashOption) {
        this.fieldDefinitionPath = fieldDefinitionPath;
        this.parentPath = parentPath;
        this.fieldName = fieldName;
        this.streams = streams;
        this.attributes = attributes;
        this.toSetAccess = toSetAccess;
        this.clashOption = clashOption;
    }

    public RegisterFileSetRequest() {
    }

    public static enum ClashOptions {
        REPLACE_EXISTING,
        MERGE_EXISTING,
        APPEND;

    }
}

