package org.gcube.application.geoportal.common.utils;

import com.jayway.jsonpath.Configuration;
import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Option;
import lombok.Getter;

import java.util.List;

public class JSONPathWrapper {

    public static Configuration JSON_PATH_ALWAYS_LIST_CONFIG=null;
    public static Configuration JSON_PATH_PATHS_CONFIGURATION=null;

    static {
        JSON_PATH_ALWAYS_LIST_CONFIG= Configuration.builder().options(Option.ALWAYS_RETURN_LIST,Option.SUPPRESS_EXCEPTIONS,Option.DEFAULT_PATH_LEAF_TO_NULL).build();
        JSON_PATH_PATHS_CONFIGURATION = Configuration.builder().options(Option.AS_PATH_LIST,Option.SUPPRESS_EXCEPTIONS,Option.DEFAULT_PATH_LEAF_TO_NULL).build();
    }


    @Getter
    DocumentContext ctx=null;

    public JSONPathWrapper(String json) {
        ctx=JsonPath.using(JSON_PATH_ALWAYS_LIST_CONFIG).parse(json);
    }

    public List<Object> getByPath(String path){
        throw new RuntimeException("TO IMPLEMENT");
    }


}
