package org.gcube.application.geoportal.common.rest;

import org.bson.Document;
import org.gcube.application.geoportal.common.model.document.ProfiledDocument;
import org.gcube.application.geoportal.common.model.rest.Configuration;
import org.gcube.application.geoportal.common.model.rest.QueryRequest;

import java.rmi.RemoteException;
import java.util.Iterator;

public interface ProfiledDocumentsI<P extends ProfiledDocument> {

	// CRUD
	public P createNew(Document toCreate)throws RemoteException;
	public void deleteById(String id) throws RemoteException;
	public void deleteById(String id,Boolean force) throws RemoteException;
	public P getById(String id) throws RemoteException;

	// CONFIG
	public Configuration getConfiguration() throws RemoteException;

	// QUERY
	public Iterator<P> query (QueryRequest request) throws RemoteException;
	public String querForJSON(QueryRequest request)throws RemoteException;

	//Execution
	public P performStep(String id, String step, Document request);
}
