package org.gcube.application.geoportal.common.model.document;

import com.mongodb.client.model.geojson.GeoJsonObjectType;
import lombok.*;
import org.bson.Document;


@NoArgsConstructor
@AllArgsConstructor
@Getter
@Setter
@ToString
public class ProfiledDocument {

    public static final String _ID="_id";
    public static final String VERSION="version";
    public static final String INFO="info";
    public static final String PROFILE_ID="profileID";
    public static final String PROFILE_VERSION="profileVersion";
    public static final String LIFECYCLE_INFORMATION="lifecycleInformation";
    public static final String RELATIONSHIPS="relationships";
    public static final String SPATIAL_REFERENCE="spatialReference";
    public static final String TEMPORAL_REFERENCE="temporalReference";
    public static final String THE_DOCUMENT="theDocument";

    // CORE METADATA

    private String _id;
    private ComparableVersion version;

    // Publication Info
    private PublicationInfo info;

    // Profile reference
    private String profileID;
    private ComparableVersion profileVersion;

    private LifecycleInformation lifecycleInformation;

    private Relationship[] relationships;

    private GeoJsonObjectType spatialReference;

    private TemporalReference temporalReference;

    private Document theDocument;

    public void setDefaults(){
        // TODO APPLY DEFAULTS ??

    };
}
