package org.gcube.application.geoportal.common.model.document;

import lombok.*;

import java.util.List;

@NoArgsConstructor
@AllArgsConstructor
@Getter
@Setter
@ToString
public class LifecycleInformation {

    public static final String PHASE="phase";
    public static final String LAST_OPERATION_STATUS="lastOperationStatus";
    public static final String ERROR_MESSAGES="errorMessages";
    public static final String WARNING_MESSAGES="warningMEssages";
    public static final String CHILDREN="children";

    public static enum Status{
        PASSED,ERROR,WARNING
    }


    private String phase;
    private Status lastOperationStatus;
    private List<String> errorMessages;
    private List<String> warningMessages;
    private List<LifecycleInformation> children;

}
