package org.gcube.application.geoportal.common.rest;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.gcube.application.geoportal.common.faults.InvalidRequestException;

@Data
@NoArgsConstructor
@AllArgsConstructor
public class TempFile {

	private String id;
	private String filename;

	public void validate()throws InvalidRequestException {
		if(id==null || id.isEmpty()) throw new InvalidRequestException("Invalid temp file "+this+" : ID null or empty");
		if(filename==null || filename.isEmpty()) throw new InvalidRequestException("Invalid temp file "+this+" : filename null or empty");
	}
}
