package org.gcube.application.geoportal.common.model.profile;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.xml.bind.annotation.XmlRootElement;

import lombok.Data;
import lombok.Getter;
import lombok.NoArgsConstructor;
import org.bson.Document;
import org.gcube.application.geoportal.common.model.document.AccountingInfo;
import org.gcube.application.geoportal.common.model.document.ComparableVersion;

@Data
@NoArgsConstructor
@XmlRootElement
public class Profile{

	private String id;
	private ComparableVersion version;

	private String name;
	private String description;
	private AccountingInfo creationInfo;

	private Document schema;

	private List<HandlerDeclaration> handlers;

	/**
	 * Returns map Type -> Handler Declaration
	 * @return
	 */
	public Map<String,List<HandlerDeclaration>> getHandlersMap(){
		HashMap<String,List<HandlerDeclaration>> toReturn=new HashMap<>();
		handlers.forEach(h->{
			if(!toReturn.containsKey(h.getType()))
				toReturn.put(h.getType(),new ArrayList<>());
			toReturn.get(h.getType()).add(h);
		});
		return toReturn;
	}
}
