/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.geoportal.common.model.configuration;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlRootElement;
import org.gcube.application.geoportal.common.model.configuration.Archive;
import org.gcube.application.geoportal.common.model.configuration.Index;

@XmlRootElement
public class Configuration {
    public static final String PROFILE_ID = "profile_id";
    public static final String CONTEXT = "context";
    public static final String LAST_UPDATED_TIME = "last_updated_time";
    public static final String ERROR_MESSAGES = "errorMessages";
    public static final String WARNING_MESSAGES = "warningMessages";
    public static final String STATUS = "status";
    public static final String INDEXES = "indexes";
    public static final String ARCHIVES = "archives";
    @JsonProperty(value="profile_id")
    private String profileId;
    @JsonProperty(value="context")
    private String context;
    @JsonProperty(value="last_updated_time")
    private LocalDateTime lastUpdatedTime;
    @JsonProperty(value="indexes")
    private List<Index> indexes;
    @JsonProperty(value="archives")
    private List<Archive> archives;
    @JsonProperty(value="errorMessages")
    private List<String> errorMessages;
    @JsonProperty(value="warningMessages")
    private List<String> warningMessages;
    @JsonProperty(value="status")
    private Status status = Status.OK;

    @JsonIgnore
    public Configuration addErrorMessage(String msg) {
        this.status = Status.ERROR;
        if (this.errorMessages == null) {
            this.errorMessages = new ArrayList<String>();
        }
        this.errorMessages.add(msg);
        return this;
    }

    @JsonIgnore
    public Configuration addWarningMessage(String msg) {
        if (this.status == null || this.status.equals((Object)Status.OK)) {
            this.status = Status.WARNING;
        }
        if (this.warningMessages == null) {
            this.warningMessages = new ArrayList<String>();
        }
        this.warningMessages.add(msg);
        return this;
    }

    public String getProfileId() {
        return this.profileId;
    }

    public String getContext() {
        return this.context;
    }

    public LocalDateTime getLastUpdatedTime() {
        return this.lastUpdatedTime;
    }

    public List<Index> getIndexes() {
        return this.indexes;
    }

    public List<Archive> getArchives() {
        return this.archives;
    }

    public List<String> getErrorMessages() {
        return this.errorMessages;
    }

    public List<String> getWarningMessages() {
        return this.warningMessages;
    }

    public Status getStatus() {
        return this.status;
    }

    public void setProfileId(String profileId) {
        this.profileId = profileId;
    }

    public void setContext(String context) {
        this.context = context;
    }

    public void setLastUpdatedTime(LocalDateTime lastUpdatedTime) {
        this.lastUpdatedTime = lastUpdatedTime;
    }

    public void setIndexes(List<Index> indexes) {
        this.indexes = indexes;
    }

    public void setArchives(List<Archive> archives) {
        this.archives = archives;
    }

    public void setErrorMessages(List<String> errorMessages) {
        this.errorMessages = errorMessages;
    }

    public void setWarningMessages(List<String> warningMessages) {
        this.warningMessages = warningMessages;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Configuration)) {
            return false;
        }
        Configuration other = (Configuration)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$profileId = this.getProfileId();
        String other$profileId = other.getProfileId();
        if (this$profileId == null ? other$profileId != null : !this$profileId.equals(other$profileId)) {
            return false;
        }
        String this$context = this.getContext();
        String other$context = other.getContext();
        if (this$context == null ? other$context != null : !this$context.equals(other$context)) {
            return false;
        }
        LocalDateTime this$lastUpdatedTime = this.getLastUpdatedTime();
        LocalDateTime other$lastUpdatedTime = other.getLastUpdatedTime();
        if (this$lastUpdatedTime == null ? other$lastUpdatedTime != null : !((Object)this$lastUpdatedTime).equals(other$lastUpdatedTime)) {
            return false;
        }
        List<Index> this$indexes = this.getIndexes();
        List<Index> other$indexes = other.getIndexes();
        if (this$indexes == null ? other$indexes != null : !((Object)this$indexes).equals(other$indexes)) {
            return false;
        }
        List<Archive> this$archives = this.getArchives();
        List<Archive> other$archives = other.getArchives();
        if (this$archives == null ? other$archives != null : !((Object)this$archives).equals(other$archives)) {
            return false;
        }
        List<String> this$errorMessages = this.getErrorMessages();
        List<String> other$errorMessages = other.getErrorMessages();
        if (this$errorMessages == null ? other$errorMessages != null : !((Object)this$errorMessages).equals(other$errorMessages)) {
            return false;
        }
        List<String> this$warningMessages = this.getWarningMessages();
        List<String> other$warningMessages = other.getWarningMessages();
        if (this$warningMessages == null ? other$warningMessages != null : !((Object)this$warningMessages).equals(other$warningMessages)) {
            return false;
        }
        Status this$status = this.getStatus();
        Status other$status = other.getStatus();
        return !(this$status == null ? other$status != null : !((Object)((Object)this$status)).equals((Object)other$status));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Configuration;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $profileId = this.getProfileId();
        result = result * 59 + ($profileId == null ? 43 : $profileId.hashCode());
        String $context = this.getContext();
        result = result * 59 + ($context == null ? 43 : $context.hashCode());
        LocalDateTime $lastUpdatedTime = this.getLastUpdatedTime();
        result = result * 59 + ($lastUpdatedTime == null ? 43 : ((Object)$lastUpdatedTime).hashCode());
        List<Index> $indexes = this.getIndexes();
        result = result * 59 + ($indexes == null ? 43 : ((Object)$indexes).hashCode());
        List<Archive> $archives = this.getArchives();
        result = result * 59 + ($archives == null ? 43 : ((Object)$archives).hashCode());
        List<String> $errorMessages = this.getErrorMessages();
        result = result * 59 + ($errorMessages == null ? 43 : ((Object)$errorMessages).hashCode());
        List<String> $warningMessages = this.getWarningMessages();
        result = result * 59 + ($warningMessages == null ? 43 : ((Object)$warningMessages).hashCode());
        Status $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : ((Object)((Object)$status)).hashCode());
        return result;
    }

    public String toString() {
        return "Configuration(profileId=" + this.getProfileId() + ", context=" + this.getContext() + ", lastUpdatedTime=" + this.getLastUpdatedTime() + ", indexes=" + this.getIndexes() + ", archives=" + this.getArchives() + ", errorMessages=" + this.getErrorMessages() + ", warningMessages=" + this.getWarningMessages() + ", status=" + (Object)((Object)this.getStatus()) + ")";
    }

    public Configuration(String profileId, String context, LocalDateTime lastUpdatedTime, List<Index> indexes, List<Archive> archives, List<String> errorMessages, List<String> warningMessages, Status status) {
        this.profileId = profileId;
        this.context = context;
        this.lastUpdatedTime = lastUpdatedTime;
        this.indexes = indexes;
        this.archives = archives;
        this.errorMessages = errorMessages;
        this.warningMessages = warningMessages;
        this.status = status;
    }

    public Configuration() {
    }

    public static enum Status {
        OK,
        ERROR,
        WARNING;

    }
}

