/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.geoportal.common.model.useCaseDescriptor;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.vdurmont.semver4j.Semver;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.xml.bind.annotation.XmlRootElement;
import org.bson.types.ObjectId;
import org.gcube.application.geoportal.common.model.document.accounting.AccountingInfo;
import org.gcube.application.geoportal.common.model.document.accounting.User;
import org.gcube.application.geoportal.common.model.useCaseDescriptor.DataAccessPolicy;
import org.gcube.application.geoportal.common.model.useCaseDescriptor.Field;
import org.gcube.application.geoportal.common.model.useCaseDescriptor.HandlerDeclaration;
import org.gcube.application.geoportal.common.model.useCaseDescriptor.RelationshipDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@XmlRootElement
public class UseCaseDescriptor
implements Serializable {
    private static final Logger log = LoggerFactory.getLogger(UseCaseDescriptor.class);
    public static final String MONGO_ID = "_mongoId";
    public static final String ID = "_id";
    public static final String VERSION = "_version";
    public static final String NAME = "_name";
    public static final String DESCRIPTION = "_description";
    public static final String CREATION_INFO = "_creationInfo";
    public static final String SCHEMA = "_schema";
    public static final String HANDLERS = "_handlers";
    public static final String DATA_ACCESS_POLICIES = "_dataAccessPolicies";
    public static final String RELATIONSHIP_DEFINITIONS = "_relationshipDefinitions";
    @JsonProperty(value="_mongoId")
    private ObjectId mongoId;
    @JsonProperty(value="_id")
    private String id;
    @JsonProperty(value="_version")
    private Semver version;
    @JsonProperty(value="_name")
    private String name;
    @JsonProperty(value="_description")
    private String description;
    @JsonProperty(value="_creationInfo")
    private AccountingInfo creationInfo;
    @JsonProperty(value="_schema")
    private Field schema;
    @JsonProperty(value="_handlers")
    private List<HandlerDeclaration> handlers;
    @JsonProperty(value="_dataAccessPolicies")
    private List<DataAccessPolicy> dataAccessPolicies;
    @JsonProperty(value="_relationshipDefinitions")
    private List<RelationshipDefinition> relationshipDefinitions;

    @JsonIgnore
    public Map<String, List<HandlerDeclaration>> getHandlersMapByType() {
        HashMap<String, List<HandlerDeclaration>> toReturn = new HashMap<String, List<HandlerDeclaration>>();
        this.handlers.forEach(h -> {
            try {
                if (!toReturn.containsKey(h.getType())) {
                    toReturn.put(h.getType(), new ArrayList());
                }
                ((List)toReturn.get(h.getType())).add(h);
            }
            catch (Throwable t) {
                log.error("Invalid useCaseDescriptor : unable to get Handler Map by Type with {} in useCaseDescriptor [ID {}]", new Object[]{h, this.getId(), t});
            }
        });
        if (log.isTraceEnabled()) {
            toReturn.forEach((s, handlerDeclarations) -> log.trace("UCD {} : Found N {} handlers of type {}", new Object[]{this.getId(), handlerDeclarations.size(), s}));
        }
        return toReturn;
    }

    @JsonIgnore
    public List<HandlerDeclaration> getHandlersByType(String type) {
        List<HandlerDeclaration> toReturn = ((Stream)this.handlers.stream().sequential()).filter(handlerDeclaration -> handlerDeclaration.getType().equals(type)).collect(Collectors.toList());
        log.debug("UCD {} : Found {} Handlers for {}", new Object[]{this.getId(), toReturn.size(), type});
        return toReturn;
    }

    @JsonIgnore
    public Map<String, List<HandlerDeclaration>> getHandlersMapByID() {
        HashMap<String, List<HandlerDeclaration>> toReturn = new HashMap<String, List<HandlerDeclaration>>();
        this.handlers.forEach(h -> {
            try {
                if (!toReturn.containsKey(h.getId())) {
                    toReturn.put(h.getId(), new ArrayList());
                }
                ((List)toReturn.get(h.getId())).add(h);
            }
            catch (Throwable t) {
                log.error("Invalid useCaseDescriptor : unable to get Handler Map by ID with {} in useCaseDescriptor [ID {}]", new Object[]{h, this.getId(), t});
            }
        });
        return toReturn;
    }

    @JsonIgnore
    public DataAccessPolicy getMatching(User u) {
        DataAccessPolicy defaultPolicy = null;
        if (this.dataAccessPolicies != null) {
            for (DataAccessPolicy dataAccessPolicy : this.dataAccessPolicies) {
                if (dataAccessPolicy.getRoles() == null || dataAccessPolicy.getRoles().isEmpty()) {
                    defaultPolicy = dataAccessPolicy;
                }
                for (String r : dataAccessPolicy.getRoles()) {
                    if (!u.getRoles().contains(r)) continue;
                    return dataAccessPolicy;
                }
            }
        }
        return defaultPolicy;
    }

    public ObjectId getMongoId() {
        return this.mongoId;
    }

    public String getId() {
        return this.id;
    }

    public Semver getVersion() {
        return this.version;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public AccountingInfo getCreationInfo() {
        return this.creationInfo;
    }

    public Field getSchema() {
        return this.schema;
    }

    public List<HandlerDeclaration> getHandlers() {
        return this.handlers;
    }

    public List<DataAccessPolicy> getDataAccessPolicies() {
        return this.dataAccessPolicies;
    }

    public List<RelationshipDefinition> getRelationshipDefinitions() {
        return this.relationshipDefinitions;
    }

    public void setMongoId(ObjectId mongoId) {
        this.mongoId = mongoId;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setVersion(Semver version) {
        this.version = version;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setCreationInfo(AccountingInfo creationInfo) {
        this.creationInfo = creationInfo;
    }

    public void setSchema(Field schema) {
        this.schema = schema;
    }

    public void setHandlers(List<HandlerDeclaration> handlers) {
        this.handlers = handlers;
    }

    public void setDataAccessPolicies(List<DataAccessPolicy> dataAccessPolicies) {
        this.dataAccessPolicies = dataAccessPolicies;
    }

    public void setRelationshipDefinitions(List<RelationshipDefinition> relationshipDefinitions) {
        this.relationshipDefinitions = relationshipDefinitions;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UseCaseDescriptor)) {
            return false;
        }
        UseCaseDescriptor other = (UseCaseDescriptor)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ObjectId this$mongoId = this.getMongoId();
        ObjectId other$mongoId = other.getMongoId();
        if (this$mongoId == null ? other$mongoId != null : !this$mongoId.equals(other$mongoId)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        Semver this$version = this.getVersion();
        Semver other$version = other.getVersion();
        if (this$version == null ? other$version != null : !this$version.equals(other$version)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        AccountingInfo this$creationInfo = this.getCreationInfo();
        AccountingInfo other$creationInfo = other.getCreationInfo();
        if (this$creationInfo == null ? other$creationInfo != null : !this$creationInfo.equals(other$creationInfo)) {
            return false;
        }
        Field this$schema = this.getSchema();
        Field other$schema = other.getSchema();
        if (this$schema == null ? other$schema != null : !((Object)((Object)this$schema)).equals((Object)other$schema)) {
            return false;
        }
        List<HandlerDeclaration> this$handlers = this.getHandlers();
        List<HandlerDeclaration> other$handlers = other.getHandlers();
        if (this$handlers == null ? other$handlers != null : !((Object)this$handlers).equals(other$handlers)) {
            return false;
        }
        List<DataAccessPolicy> this$dataAccessPolicies = this.getDataAccessPolicies();
        List<DataAccessPolicy> other$dataAccessPolicies = other.getDataAccessPolicies();
        if (this$dataAccessPolicies == null ? other$dataAccessPolicies != null : !((Object)this$dataAccessPolicies).equals(other$dataAccessPolicies)) {
            return false;
        }
        List<RelationshipDefinition> this$relationshipDefinitions = this.getRelationshipDefinitions();
        List<RelationshipDefinition> other$relationshipDefinitions = other.getRelationshipDefinitions();
        return !(this$relationshipDefinitions == null ? other$relationshipDefinitions != null : !((Object)this$relationshipDefinitions).equals(other$relationshipDefinitions));
    }

    protected boolean canEqual(Object other) {
        return other instanceof UseCaseDescriptor;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ObjectId $mongoId = this.getMongoId();
        result = result * 59 + ($mongoId == null ? 43 : $mongoId.hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        Semver $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : $version.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        AccountingInfo $creationInfo = this.getCreationInfo();
        result = result * 59 + ($creationInfo == null ? 43 : $creationInfo.hashCode());
        Field $schema = this.getSchema();
        result = result * 59 + ($schema == null ? 43 : ((Object)((Object)$schema)).hashCode());
        List<HandlerDeclaration> $handlers = this.getHandlers();
        result = result * 59 + ($handlers == null ? 43 : ((Object)$handlers).hashCode());
        List<DataAccessPolicy> $dataAccessPolicies = this.getDataAccessPolicies();
        result = result * 59 + ($dataAccessPolicies == null ? 43 : ((Object)$dataAccessPolicies).hashCode());
        List<RelationshipDefinition> $relationshipDefinitions = this.getRelationshipDefinitions();
        result = result * 59 + ($relationshipDefinitions == null ? 43 : ((Object)$relationshipDefinitions).hashCode());
        return result;
    }

    public String toString() {
        return "UseCaseDescriptor(mongoId=" + this.getMongoId() + ", id=" + this.getId() + ", version=" + this.getVersion() + ", name=" + this.getName() + ", description=" + this.getDescription() + ", creationInfo=" + this.getCreationInfo() + ", schema=" + (Object)((Object)this.getSchema()) + ", handlers=" + this.getHandlers() + ", dataAccessPolicies=" + this.getDataAccessPolicies() + ", relationshipDefinitions=" + this.getRelationshipDefinitions() + ")";
    }
}

