/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.geoportal.common.model.useCaseDescriptor;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import org.bson.Document;
import org.gcube.application.geoportal.common.model.document.Project;
import org.gcube.application.geoportal.common.model.document.accounting.User;

public class DataAccessPolicy {
    public static final String POLICY = "_policy";
    public static final String ROLES = "_roles";
    public static final String ENFORCER = "_enforcer";
    @JsonProperty(value="_policy")
    private Policy policy;
    @JsonProperty(value="_roles")
    private List<String> roles;
    @JsonProperty(value="_enforcer")
    private PolicyEnforcer enforcer;

    @JsonIgnore
    public boolean canRead(Project p, User u) {
        switch (this.getPolicy().getRead()) {
            case own: {
                return p.getInfo().getCreationInfo().getUser().equals(u);
            }
            case any: {
                return true;
            }
        }
        return false;
    }

    @JsonIgnore
    public boolean canWrite(Project p, User u) {
        switch (this.getPolicy().getWrite()) {
            case own: {
                return p.getInfo().getCreationInfo().getUser().equals(u);
            }
            case any: {
                return true;
            }
        }
        return false;
    }

    public DataAccessPolicy() {
    }

    public DataAccessPolicy(Policy policy, List<String> roles, PolicyEnforcer enforcer) {
        this.policy = policy;
        this.roles = roles;
        this.enforcer = enforcer;
    }

    public Policy getPolicy() {
        return this.policy;
    }

    public List<String> getRoles() {
        return this.roles;
    }

    public PolicyEnforcer getEnforcer() {
        return this.enforcer;
    }

    public void setPolicy(Policy policy) {
        this.policy = policy;
    }

    public void setRoles(List<String> roles) {
        this.roles = roles;
    }

    public void setEnforcer(PolicyEnforcer enforcer) {
        this.enforcer = enforcer;
    }

    public String toString() {
        return "DataAccessPolicy(policy=" + this.getPolicy() + ", roles=" + this.getRoles() + ", enforcer=" + this.getEnforcer() + ")";
    }

    public static class PolicyEnforcer {
        public static final String FILTER = "_filter";
        @JsonProperty(value="_filter")
        private String filter;

        @JsonIgnore
        public Document getFilterDocument() {
            if (this.filter != null) {
                return Document.parse((String)this.filter);
            }
            return new Document();
        }

        public PolicyEnforcer() {
        }

        public PolicyEnforcer(String filter) {
            this.filter = filter;
        }

        public String getFilter() {
            return this.filter;
        }

        public void setFilter(String filter) {
            this.filter = filter;
        }

        public String toString() {
            return "DataAccessPolicy.PolicyEnforcer(filter=" + this.getFilter() + ")";
        }
    }

    public static class Policy {
        public static final String WRITE = "_write";
        public static final String READ = "_read";
        @JsonProperty(value="_write")
        private Type write;
        @JsonProperty(value="_read")
        private Type read;

        public Policy() {
        }

        public Policy(Type write, Type read) {
            this.write = write;
            this.read = read;
        }

        public Type getWrite() {
            return this.write;
        }

        public Type getRead() {
            return this.read;
        }

        public void setWrite(Type write) {
            this.write = write;
        }

        public void setRead(Type read) {
            this.read = read;
        }

        public String toString() {
            return "DataAccessPolicy.Policy(write=" + (Object)((Object)this.getWrite()) + ", read=" + (Object)((Object)this.getRead()) + ")";
        }

        public static enum Type {
            own,
            none,
            any;

        }
    }
}

