/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.geoportal.common.model.document.filesets.sdi;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.List;
import java.util.Map;
import org.bson.Document;
import org.gcube.application.geoportal.common.model.document.filesets.Materialization;

public class GCubeSDILayer
extends Materialization {
    public static final String GCUBE_SDY_LAYER_TYPE = "gcube-sdi-layer";
    public static final String OGC_LINKS = "_ogcLinks";
    public static final String B_BOX = "_bbox";
    public static final String PLATFORM_INFO = "_platformInfo";

    public GCubeSDILayer() {
        super(GCUBE_SDY_LAYER_TYPE);
    }

    @JsonIgnore
    public Map getOGCLinks() {
        return (Map)this.get(OGC_LINKS, Map.class);
    }

    @JsonIgnore
    public Object getBBox() {
        return this.get(B_BOX);
    }

    @JsonIgnore
    public List getPlatformInfo() {
        return (List)this.get(PLATFORM_INFO, List.class);
    }

    public static class BBOX
    extends Document {
        public static final BBOX WORLD = new BBOX(180.0, -180.0, 90.0, -90.0);
        public static final BBOX WORLD_3D = new BBOX(180.0, -180.0, 90.0, -90.0);
        public static final String MAX_X = "_maxX";
        public static final String MAX_Y = "_maxY";
        public static final String MAX_Z = "_maxZ";
        public static final String MIN_X = "_minX";
        public static final String MIN_Y = "_minY";
        public static final String MIN_Z = "_minZ";

        public final String asGeoJSONBBox() {
            StringBuilder builder = new StringBuilder("[");
            builder.append(this.getMaxX() + ",");
            builder.append(this.getMinY() + ",");
            if (this.is3d().booleanValue()) {
                builder.append(this.getMinZ() + ",");
            }
            builder.append(this.getMinX() + ",");
            builder.append(this.getMaxY() + ",");
            if (this.is3d().booleanValue()) {
                builder.append(this.getMaxZ() + ",");
            }
            builder.deleteCharAt(builder.length());
            builder.append("]");
            return builder.toString();
        }

        public double[] asGeoJSONArray() {
            if (this.is3d().booleanValue()) {
                return new double[]{this.getMaxX(), this.getMinY(), this.getMinZ(), this.getMinX(), this.getMaxY(), this.getMaxZ()};
            }
            return new double[]{this.getMaxX(), this.getMinY(), this.getMinX(), this.getMaxY()};
        }

        public static final BBOX fromGeoJSON(double[] coords) {
            BBOX toReturn = new BBOX();
            toReturn.setMaxX(coords[0]);
            toReturn.setMinY(coords[1]);
            if (coords.length == 6) {
                toReturn.setMinZ(coords[2]);
                toReturn.setMinX(coords[3]);
                toReturn.setMaxY(coords[4]);
                toReturn.setMaxZ(coords[5]);
            } else {
                toReturn.setMinX(coords[2]);
                toReturn.setMaxY(coords[3]);
            }
            return toReturn;
        }

        public BBOX(Double maxX, Double minX, Double maxY, Double minY, Double maxZ, Double minZ) {
            this(maxX, minX, maxY, minY);
            this.setMaxZ(maxZ);
            this.setMinZ(minZ);
        }

        public BBOX(Double maxX, Double minX, Double maxY, Double minY) {
            this.setMaxX(maxX);
            this.setMinX(minX);
            this.setMaxY(maxY);
            this.setMinY(minY);
        }

        @JsonIgnore
        public BBOX setMaxX(Double d) {
            this.put(MAX_X, d);
            return this;
        }

        @JsonIgnore
        public BBOX setMaxY(Double d) {
            this.put(MAX_Y, d);
            return this;
        }

        @JsonIgnore
        public BBOX setMaxZ(Double d) {
            this.put(MAX_Z, d);
            return this;
        }

        @JsonIgnore
        public BBOX setMinX(Double d) {
            this.put(MIN_X, d);
            return this;
        }

        @JsonIgnore
        public BBOX setMinY(Double d) {
            this.put(MIN_Y, d);
            return this;
        }

        @JsonIgnore
        public BBOX setMinZ(Double d) {
            this.put(MIN_Z, d);
            return this;
        }

        @JsonIgnore
        public Double getMinY() {
            return (Double)this.getOrDefault(MIN_Y, -90.0);
        }

        @JsonIgnore
        public Double getMaxY() {
            return (Double)this.getOrDefault(MAX_Y, 90.0);
        }

        @JsonIgnore
        public Double getMinX() {
            return (Double)this.getOrDefault(MIN_X, -180.0);
        }

        @JsonIgnore
        public Double getMaxX() {
            return (Double)this.getOrDefault(MAX_X, 180.0);
        }

        @JsonIgnore
        public Double getMinZ() {
            return (Double)this.getOrDefault(MIN_Z, null);
        }

        @JsonIgnore
        public Double getMaxZ() {
            return (Double)this.getOrDefault(MAX_Z, null);
        }

        @JsonIgnore
        public Boolean is3d() {
            return this.getMinZ() != null && this.getMaxZ() != null;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof BBOX)) {
                return false;
            }
            BBOX other = (BBOX)((Object)o);
            return other.canEqual((Object)this);
        }

        protected boolean canEqual(Object other) {
            return other instanceof BBOX;
        }

        public int hashCode() {
            int result = 1;
            return result;
        }

        public String toString() {
            return "GCubeSDILayer.BBOX()";
        }

        public BBOX() {
        }
    }
}

