/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.cms.plugins.implementations;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.HashMap;
import java.util.List;
import javax.xml.bind.annotation.XmlRootElement;
import org.gcube.application.cms.serialization.Serialization;
import org.gcube.application.geoportal.common.model.document.accounting.User;
import org.gcube.application.geoportal.common.model.rest.ConfigurationException;
import org.gcube.application.geoportal.common.model.useCaseDescriptor.HandlerDeclaration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RoleManager {
    private static final Logger log = LoggerFactory.getLogger(RoleManager.class);
    HashMap<String, StepAccess> accessMap = new HashMap();

    public RoleManager(HandlerDeclaration config) throws ConfigurationException {
        log.debug("Instantiating for configuration {}", (Object)config);
        List l = (List)config.getConfiguration().get((Object)"step_access", List.class);
        if (l == null || l.isEmpty()) {
            throw new ConfigurationException("Missing Role management in UCD");
        }
        for (Object o : l) {
            StepAccess a = (StepAccess)Serialization.convert(o, StepAccess.class);
            this.accessMap.put(a.getStepId(), a);
        }
        log.debug("Access Map is {}", this.accessMap);
    }

    public boolean canInvokeStep(String stepID, User u) throws ConfigurationException {
        if (!this.accessMap.containsKey(stepID)) {
            throw new ConfigurationException("Missing step " + stepID + " access definition");
        }
        List<String> roles = this.accessMap.get(stepID).getRoles();
        if (roles.isEmpty()) {
            return true;
        }
        for (String role : roles) {
            if (!u.getRoles().contains(role)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return "RoleManager(accessMap=" + this.accessMap + ")";
    }

    @XmlRootElement
    public static class StepAccess {
        public static final String STEP = "STEP";
        public static final String ROLES = "roles";
        @JsonProperty(value="STEP")
        private String stepId;
        @JsonProperty(value="roles")
        private List<String> roles;

        public StepAccess() {
        }

        public StepAccess(String stepId, List<String> roles) {
            this.stepId = stepId;
            this.roles = roles;
        }

        public String getStepId() {
            return this.stepId;
        }

        public List<String> getRoles() {
            return this.roles;
        }

        public void setStepId(String stepId) {
            this.stepId = stepId;
        }

        public void setRoles(List<String> roles) {
            this.roles = roles;
        }

        public String toString() {
            return "RoleManager.StepAccess(super=" + super.toString() + ", stepId=" + this.getStepId() + ", roles=" + this.getRoles() + ")";
        }
    }
}

