/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.cms.plugins.implementations.executions;

import lombok.NonNull;
import org.gcube.application.cms.plugins.faults.InsufficientPrivileges;
import org.gcube.application.cms.plugins.faults.StepException;
import org.gcube.application.cms.plugins.implementations.RoleManager;
import org.gcube.application.cms.plugins.implementations.executions.GuardedExecution;
import org.gcube.application.cms.plugins.reports.StepExecutionReport;
import org.gcube.application.cms.plugins.requests.StepExecutionRequest;
import org.gcube.application.geoportal.common.model.plugins.OperationDescriptor;
import org.gcube.application.geoportal.common.model.rest.ConfigurationException;

public abstract class GuardedStepExecution
extends GuardedExecution<StepExecutionRequest, StepExecutionReport> {
    public GuardedStepExecution(@NonNull OperationDescriptor op) {
        super(op);
        if (op == null) {
            throw new NullPointerException("op is marked @NonNull but is null");
        }
    }

    @Override
    protected void checks() throws ConfigurationException, InsufficientPrivileges, StepException {
        super.checks();
        RoleManager r = new RoleManager(this.config);
        if (!r.canInvokeStep(((StepExecutionRequest)((StepExecutionReport)this.theReport).getTheRequest()).getStep(), ((StepExecutionRequest)((StepExecutionReport)this.theReport).getTheRequest()).getCaller())) {
            throw new InsufficientPrivileges("User is not allowed to execute " + ((StepExecutionRequest)((StepExecutionReport)this.theReport).getTheRequest()).getStep());
        }
    }
}

