/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.cms.plugins.implementations;

import com.vdurmont.semver4j.Semver;
import java.util.Collections;
import org.bson.Document;
import org.gcube.application.cms.plugins.IndexerPluginInterface;
import org.gcube.application.cms.plugins.LifecycleManager;
import org.gcube.application.cms.plugins.MaterializationPlugin;
import org.gcube.application.cms.plugins.faults.EventException;
import org.gcube.application.cms.plugins.faults.InvalidPluginRequestException;
import org.gcube.application.cms.plugins.faults.MaterializationException;
import org.gcube.application.cms.plugins.implementations.SimpleLifeCycleManager;
import org.gcube.application.cms.plugins.implementations.executions.GuardedStepExecution;
import org.gcube.application.cms.plugins.reports.EventExecutionReport;
import org.gcube.application.cms.plugins.reports.StepExecutionReport;
import org.gcube.application.cms.plugins.requests.BaseRequest;
import org.gcube.application.cms.plugins.requests.EventExecutionRequest;
import org.gcube.application.cms.plugins.requests.StepExecutionRequest;
import org.gcube.application.geoportal.common.model.JSONPathWrapper;
import org.gcube.application.geoportal.common.model.configuration.Configuration;
import org.gcube.application.geoportal.common.model.configuration.Index;
import org.gcube.application.geoportal.common.model.document.lifecycle.LifecycleInformation;
import org.gcube.application.geoportal.common.model.plugins.OperationDescriptor;
import org.gcube.application.geoportal.common.model.rest.ConfigurationException;
import org.gcube.application.geoportal.common.utils.Files;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Default3PhaseManager
extends SimpleLifeCycleManager
implements LifecycleManager {
    private static final Logger log = LoggerFactory.getLogger(Default3PhaseManager.class);

    @Override
    protected EventExecutionReport onDeleteDocument(EventExecutionReport report) throws ConfigurationException, InvalidPluginRequestException, MaterializationException, EventException {
        report = super.onDeleteDocument(report);
        for (IndexerPluginInterface indexer : this.getIndexers((BaseRequest)report.getTheRequest())) {
            report = this.deIndex(report, indexer, this.getInternalIndexParams((BaseRequest)report.getTheRequest()));
        }
        return report;
    }

    @Override
    protected EventExecutionReport onDeleteFileSet(EventExecutionReport theReport) throws ConfigurationException, InvalidPluginRequestException, MaterializationException, EventException {
        theReport = super.onDeleteFileSet(theReport);
        String phase = ((EventExecutionRequest)theReport.getTheRequest()).getDocument().getLifecycleInformation().getPhase();
        Document parameters = null;
        if (phase.equals("Pending Approval")) {
            parameters = this.getInternalIndexParams((BaseRequest)theReport.getTheRequest());
        }
        if (phase.equals("Published")) {
            parameters = this.getPublicIndexParams((BaseRequest)theReport.getTheRequest());
        }
        if (parameters != null) {
            for (IndexerPluginInterface indexer : this.getIndexers((BaseRequest)theReport.getTheRequest())) {
                theReport = this.index(theReport, indexer, this.getPublicIndexParams((BaseRequest)theReport.getTheRequest()));
            }
        }
        return theReport;
    }

    @Override
    protected void registerSteps() {
        this.setStep(new GuardedStepExecution(STEPS.SUBMIT){

            @Override
            protected StepExecutionReport run() throws Exception {
                return Default3PhaseManager.this.executeSubmit((StepExecutionReport)this.theReport);
            }
        });
        this.setStep(new GuardedStepExecution(STEPS.APPROVE){

            @Override
            protected StepExecutionReport run() throws Exception {
                return Default3PhaseManager.this.executeApprove((StepExecutionReport)this.theReport);
            }
        });
        this.setStep(new GuardedStepExecution(STEPS.REJECT){

            @Override
            protected StepExecutionReport run() throws Exception {
                return Default3PhaseManager.this.executeReject((StepExecutionReport)this.theReport);
            }
        });
        this.setStep(this.d3PhaseUnPublishStep());
    }

    public Default3PhaseManager() {
        this.DESCRIPTOR.setId("DEFAULT-3PHASE");
        this.DESCRIPTOR.setDescription("Default 3-phase lifecycle manager. This plugin supports a simple moderated publication lifecycle.");
        this.DESCRIPTOR.setVersion(new Semver("1.0.0"));
        this.DESCRIPTOR.setLabel("Default 3-Phase");
    }

    protected GuardedStepExecution d3PhaseUnPublishStep() {
        return new GuardedStepExecution(STEPS.UNPUBLISH){

            @Override
            protected StepExecutionReport run() throws Exception {
                log.info(STEPS.UNPUBLISH + " running...");
                JSONPathWrapper wrapper = new JSONPathWrapper(((StepExecutionRequest)((StepExecutionReport)this.theReport).getTheRequest()).getDocument().getTheDocument().toJson());
                for (String s : wrapper.getMatchingPaths("$..[?(@._payloads)]")) {
                    log.info("Requesting dematerialization for {} ", (Object)s);
                    for (MaterializationPlugin mat : Default3PhaseManager.this.getMaterializers((BaseRequest)((StepExecutionReport)this.theReport).getTheRequest())) {
                        this.theReport = Default3PhaseManager.this.deMaterialize((StepExecutionReport)this.theReport, mat, new Document("fileSetPath", (Object)s));
                    }
                    if (((StepExecutionReport)this.theReport).getToSetLifecycleInformation().getLastOperationStatus().equals((Object)LifecycleInformation.Status.OK)) continue;
                    break;
                }
                if (((StepExecutionReport)this.theReport).getToSetLifecycleInformation().getLastOperationStatus().equals((Object)LifecycleInformation.Status.OK)) {
                    for (IndexerPluginInterface indexer : Default3PhaseManager.this.getIndexers((BaseRequest)((StepExecutionReport)this.theReport).getTheRequest())) {
                        log.info("Requesting deindexing for {} ", (Object)indexer.getDescriptor());
                        this.theReport = Default3PhaseManager.this.deIndex((StepExecutionReport)this.theReport, indexer, Default3PhaseManager.this.getPublicIndexParams((BaseRequest)((StepExecutionReport)this.theReport).getTheRequest()));
                        this.theReport = Default3PhaseManager.this.deIndex((StepExecutionReport)this.theReport, indexer, Default3PhaseManager.this.getInternalIndexParams((BaseRequest)((StepExecutionReport)this.theReport).getTheRequest()));
                    }
                }
                if (((StepExecutionReport)this.theReport).getToSetLifecycleInformation().getLastOperationStatus().equals((Object)LifecycleInformation.Status.OK)) {
                    ((StepExecutionReport)this.theReport).getToSetLifecycleInformation().setPhase("DRAFT");
                }
                return (StepExecutionReport)this.theReport;
            }
        };
    }

    @Override
    public Configuration getCurrentConfiguration(BaseRequest req) throws ConfigurationException {
        Configuration toReturn = super.getCurrentConfiguration(req);
        IndexerPluginInterface indexerPlugin = (IndexerPluginInterface)this.pluginManager.getById("SDI-Indexer-Plugin");
        BaseRequest indexRequest = new BaseRequest(req.getUseCaseDescriptor(), req.getCaller(), req.getContext());
        try {
            indexRequest.setCallParameters(this.getInternalIndexParams(req));
            Index internalIndex = indexerPlugin.getIndex(indexRequest);
            internalIndex.put("flag", (Object)"internal");
            toReturn.getIndexes().add(internalIndex);
        }
        catch (ConfigurationException e) {
            toReturn.addErrorMessage("Unable to gather information on internal GIS Centroids Index : " + e.getMessage());
            log.error("Unable to gather information on internal GIS Centroids Index", (Throwable)e);
        }
        return toReturn;
    }

    protected Document getInternalIndexParams(BaseRequest req) {
        Document callParameters = new Document();
        callParameters.put("workspace", (Object)Files.fixFilename((String)(req.getUseCaseDescriptor().getId() + "_internal_" + req.getContext().getName())));
        callParameters.put("indexName", (Object)Files.fixFilename((String)(req.getUseCaseDescriptor().getId() + "_internal_" + req.getContext().getName() + "_centroids")));
        return callParameters;
    }

    protected StepExecutionReport executeSubmit(StepExecutionReport theReport) throws Exception {
        for (MaterializationPlugin mat : this.getMaterializers((BaseRequest)theReport.getTheRequest())) {
            theReport = this.materializeDocument(theReport, mat, this.getMaterializationParameters((BaseRequest)theReport.getTheRequest()));
        }
        if (theReport.getToSetLifecycleInformation().getLastOperationStatus().equals((Object)LifecycleInformation.Status.OK)) {
            for (IndexerPluginInterface indexer : this.getIndexers((BaseRequest)theReport.getTheRequest())) {
                theReport = this.index(theReport, indexer, this.getInternalIndexParams((BaseRequest)theReport.getTheRequest()));
            }
            if (theReport.getToSetLifecycleInformation().getLastOperationStatus().equals((Object)LifecycleInformation.Status.OK)) {
                theReport.getToSetLifecycleInformation().setPhase("Pending Approval");
            }
        }
        return theReport;
    }

    protected StepExecutionReport executeApprove(StepExecutionReport theReport) throws Exception {
        for (IndexerPluginInterface indexer : this.getIndexers((BaseRequest)theReport.getTheRequest())) {
            theReport = this.index(theReport, indexer, this.getPublicIndexParams((BaseRequest)theReport.getTheRequest()));
        }
        if (theReport.getToSetLifecycleInformation().getLastOperationStatus().equals((Object)LifecycleInformation.Status.OK)) {
            theReport.getToSetLifecycleInformation().setPhase("Published");
        }
        return theReport;
    }

    protected StepExecutionReport executeReject(StepExecutionReport theReport) throws Exception {
        if (theReport.getToSetLifecycleInformation().getLastOperationStatus().equals((Object)LifecycleInformation.Status.OK)) {
            theReport.getToSetLifecycleInformation().setPhase("DRAFT");
        }
        return theReport;
    }

    private static class PARAMETERS {
        public static final String NOTES = "notes";

        private PARAMETERS() {
        }
    }

    public static final class STEPS {
        public static final OperationDescriptor SUBMIT = new OperationDescriptor("SUBMIT-FOR-REVIEW", "Submits the Draft for reviewing");
        public static final OperationDescriptor REJECT = new OperationDescriptor("REJECT-DRAFT", "Rejects the submitted Draft");
        public static final OperationDescriptor APPROVE = new OperationDescriptor("APPROVE-SUBMITTED", "Approves the submitted Draft");
        public static final OperationDescriptor UNPUBLISH = new OperationDescriptor("UNPUBLISH", "UnPublish the project. DeMaterialize and DeIndex the project");

        static {
            SUBMIT.setAppliableToPhases(Collections.singletonList("DRAFT"));
            REJECT.setAppliableToPhases(Collections.singletonList("Pending Approval"));
            APPROVE.setAppliableToPhases(Collections.singletonList("Pending Approval"));
            UNPUBLISH.setAppliableToPhases(Collections.singletonList("Published"));
        }
    }

    protected static class Phases {
        public static final String PENDING_APPROVAL = "Pending Approval";
        public static final String PUBLISHED = "Published";

        protected Phases() {
        }
    }
}

