/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.cms.tests;

import java.util.Properties;
import org.gcube.common.authorization.utils.manager.SecretManager;
import org.gcube.common.authorization.utils.manager.SecretManagerProvider;
import org.gcube.common.authorization.utils.secret.GCubeSecret;
import org.gcube.common.authorization.utils.secret.JWTSecret;
import org.gcube.common.authorization.utils.secret.Secret;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TokenSetter {
    private static final Logger log = LoggerFactory.getLogger(TokenSetter.class);
    private static Properties props = new Properties();

    public static void set(String scope) {
        SecretManagerProvider.instance.set(new SecretManager());
        if (!props.containsKey(scope)) {
            throw new RuntimeException("No token found for scope : " + scope);
        }
        String toSet = props.getProperty(scope);
        log.debug("Setting secret " + toSet);
        Object secret = null;
        secret = toSet.length() > 50 ? new JWTSecret(toSet) : new GCubeSecret(toSet);
        SecretManagerProvider.instance.get().addSecret((Secret)secret);
        try {
            SecretManagerProvider.instance.get().set();
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to set secret for context " + scope, e);
        }
    }

    static {
        try {
            props.load(TokenSetter.class.getResourceAsStream("./tokens.properties"));
        }
        catch (Exception e) {
            throw new RuntimeException("YOU NEED TO SET tokens.properties TOKEN FILE IN CONFIGURATION", e);
        }
    }
}

